/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import java.util.List;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.text.AbstractMatchFunction;
import org.exist.xquery.functions.text.FuzzyMatcher;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FuzzyMatchAll
extends AbstractMatchFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("fuzzy-match-all", "http://exist-db.org/xquery/text", "text"), "Fuzzy keyword search, which compares strings based on the Levenshtein distance (or edit distance). The function tries to match each of the keywords specified in the keyword string $b against the string value of each item in the sequence $a.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 2)}, new SequenceType(-1, 7), true);

    public FuzzyMatchAll(XQueryContext context) {
        super(context, 1, signature);
    }

    public FuzzyMatchAll(XQueryContext context, int type, FunctionSignature signature) {
        super(context, type, signature);
    }

    public Sequence evalQuery(NodeSet nodes, List terms) throws XPathException {
        if (terms == null || terms.size() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        double threshold = 0.65;
        if (this.getArgumentCount() == 3) {
            Sequence thresOpt = this.getArgument(2).eval(nodes);
            if (thresOpt.getLength() != 1) {
                throw new XPathException(this.getASTNode(), "third argument to " + this.getName() + "should be a single double value");
            }
            threshold = ((DoubleValue)thresOpt.convertTo(34)).getDouble();
        }
        NodeSet[] hits = new NodeSet[terms.size()];
        for (int k = 0; k < terms.size(); ++k) {
            String term = (String)terms.get(k);
            if (term.length() == 0) {
                hits[k] = null;
                continue;
            }
            FuzzyMatcher matcher = new FuzzyMatcher(term, threshold);
            hits[k] = this.context.getBroker().getTextEngine().getNodes(this.context, nodes.getDocumentSet(), nodes, matcher, term.substring(0, 1));
        }
        return this.mergeResults(hits);
    }
}

