/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.text.FuzzyMatcher;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FuzzyIndexTerms
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("fuzzy-index-terms", "http://exist-db.org/xquery/text", "text"), "Fuzzy keyword search, which compares strings based on the Levenshtein distance (or edit distance). The function tries to match each of the keywords specified in the keyword string $b against the string value of each item in the sequence $a.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(22, 7));

    public FuzzyIndexTerms(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        DocumentSet docs = contextSequence instanceof NodeSet ? ((NodeSet)contextSequence).getDocumentSet() : this.context.getStaticallyKnownDocuments();
        String term = args[0].getStringValue();
        String[] matches = this.context.getBroker().getTextEngine().getIndexTerms(docs, new FuzzyMatcher(term, 0.65));
        ValueSequence result = new ValueSequence();
        for (int i = 0; i < matches.length; ++i) {
            result.add(new StringValue(matches[i]));
        }
        return result;
    }
}

