/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Util;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.FunMatches;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunTokenize
extends FunMatches {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("tokenize", "http://www.w3.org/2003/05/xpath-functions"), "This function breaks the input string $a into a sequence of strings, treating any substring that matches pattern $b as a separator. The separators themselves are not returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2)}, new SequenceType(22, 6)), new FunctionSignature(new QName("tokenize", "http://www.w3.org/2003/05/xpath-functions"), "This function breaks the input string $a into a sequence of strings, treating any substring that matches pattern $b as a separator. The separators themselves are not returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 6))};

    public FunTokenize(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence stringArg = this.getArgument(0).eval(contextSequence, contextItem);
        if (stringArg.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String string = stringArg.getStringValue();
        String pattern = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        int flags = 0;
        if (this.getSignature().getArgumentCount() == 3) {
            flags = FunTokenize.parseFlags(this.getArgument(2).eval(contextSequence, contextItem).getStringValue());
        }
        try {
            if (this.prevPattern == null || !pattern.equals(this.prevPattern) || flags != this.prevFlags) {
                LOG.debug((Object)("Compiling pattern " + pattern));
                this.pat = this.compiler.compile(pattern, flags);
            }
            this.prevPattern = pattern;
            this.prevFlags = flags;
            ArrayList result = new ArrayList(10);
            Util.split(result, (PatternMatcher)this.matcher, (Pattern)this.pat, (String)string);
            ValueSequence r = new ValueSequence();
            for (int i = 0; i < result.size(); ++i) {
                r.add(new StringValue((String)result.get(i)));
            }
            return r;
        }
        catch (MalformedPatternException e) {
            throw new XPathException("Invalid regular expression: " + e.getMessage(), e);
        }
    }
}

