/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunSum
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("sum", "http://www.w3.org/2003/05/xpath-functions"), "Returns a value obtained by adding together the values in $a. If the single-argument form of the function is used, then the value returned for an empty sequence is the xs:double value 0.0e0.", new SequenceType[]{new SequenceType(20, 7)}, new SequenceType(20, 2)), new FunctionSignature(new QName("sum", "http://www.w3.org/2003/05/xpath-functions"), "Returns a value obtained by adding together the values in $a. If the single-argument form of the function is used, then the value returned for an empty sequence is the xs:double value 0.0e0. If the two-argument form is used, then the value returned for an empty sequence is the value of the $b argument.", new SequenceType[]{new SequenceType(20, 7), new SequenceType(20, 3)}, new SequenceType(20, 3))};

    public FunSum(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence inner = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence zero = IntegerValue.ZERO;
        if (this.getSignature().getArgumentCount() == 2) {
            zero = this.getArgument(1).eval(contextSequence, contextItem);
        }
        if (inner.getLength() == 0) {
            return zero;
        }
        SequenceIterator iter = inner.iterate();
        AtomicValue next = (AtomicValue)iter.nextItem();
        if (!Type.subTypeOf(next.getType(), 30)) {
            next = next.convertTo(34);
        }
        ComputableValue sum = (ComputableValue)next;
        while (iter.hasNext()) {
            next = (AtomicValue)iter.nextItem();
            if (!Type.subTypeOf(next.getType(), 30)) {
                next = next.convertTo(34);
            }
            if (((NumericValue)next).isNaN()) {
                return DoubleValue.NaN;
            }
            sum = sum.plus((NumericValue)next);
        }
        return sum;
    }
}

