/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunRoot
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("root", "http://www.w3.org/2003/05/xpath-functions"), "Returns the root of the tree to which the context node belongs. This will usually, but not necessarily, be a document node.", new SequenceType[0], new SequenceType(-1, 2)), new FunctionSignature(new QName("root", "http://www.w3.org/2003/05/xpath-functions"), "Returns the root of the tree to which $arg belongs. This will usually, but not necessarily, be a document node.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(-1, 3))};

    public FunRoot(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Item item = contextItem;
        if (this.getSignature().getArgumentCount() > 0) {
            Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
            if (seq.getLength() == 0) {
                return Sequence.EMPTY_SEQUENCE;
            }
            item = seq.itemAt(0);
        }
        if (!Type.subTypeOf(item.getType(), -1)) {
            throw new XPathException("Context item is not a node; got " + Type.getTypeName(item.getType()));
        }
        if (item instanceof NodeProxy) {
            return new NodeProxy(((NodeProxy)item).getDocument(), -1L, 9);
        }
        return (DocumentImpl)((NodeImpl)item).getOwnerDocument();
    }
}

