/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.XMLUtil;
import org.exist.util.XMLChar;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class FunId
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("id", "http://www.w3.org/2003/05/xpath-functions"), new SequenceType[]{new SequenceType(22, 7)}, new SequenceType(1, 7));

    public FunId(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Expression arg;
        Sequence idval;
        if (this.getArgumentCount() < 1) {
            throw new XPathException("function id requires one argument");
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((idval = (arg = this.getArgument(0)).eval(contextSequence)).getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        DocumentSet docs = contextSequence == null || !(contextSequence instanceof NodeSet) ? this.context.getStaticallyKnownDocuments() : contextSequence.toNodeSet().getDocumentSet();
        SequenceIterator i = idval.iterate();
        while (i.hasNext()) {
            String nextId = i.nextItem().getStringValue();
            if (nextId.indexOf(32) > -1) {
                StringTokenizer tok = new StringTokenizer(nextId, " ");
                while (tok.hasMoreTokens()) {
                    nextId = tok.nextToken();
                    if (!XMLChar.isValidNCName(nextId)) {
                        throw new XPathException(nextId + " is not a valid NCName");
                    }
                    QName id = new QName(nextId, "", null);
                    this.getId(result, docs, id);
                }
                continue;
            }
            if (!XMLChar.isValidNCName(nextId)) {
                throw new XPathException(nextId + " is not a valid NCName");
            }
            QName id = new QName(nextId, "", null);
            this.getId(result, docs, id);
        }
        return result;
    }

    private void getId(NodeSet result, DocumentSet docs, QName id) {
        NodeSet attribs = this.context.getBroker().getElementIndex().findElementsByTagName((byte)2, docs, id, null);
        Iterator i = attribs.iterator();
        while (i.hasNext()) {
            NodeProxy n = (NodeProxy)i.next();
            NodeProxy p = new NodeProxy(n.getDocument(), XMLUtil.getParentId(n.getDocument(), n.gid), 1);
            result.add(p);
        }
    }
}

