/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunGetDateTimeComponent
extends BasicFunction {
    public static final FunctionSignature fnGetDayFromDateTime = new FunctionSignature(new QName("day-from-dateTime", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $a.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnGetMonthFromDateTime = new FunctionSignature(new QName("month-from-dateTime", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $a.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnGetYearFromDateTime = new FunctionSignature(new QName("year-from-dateTime", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $a. The value may be negative.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnHoursFromDateTime = new FunctionSignature(new QName("hours-from-dateTime", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer between 0 and 23, both inclusive, representing the value of the hours component in the localized value of $arg.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnMinutesFromDateTime = new FunctionSignature(new QName("minutes-from-dateTime", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer value between 0 to 59, both inclusive, representing the value of the minutes component in the localized value of $arg.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnSecondsFromDateTime = new FunctionSignature(new QName("seconds-from-dateTime", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:decimal value between 0 and 60.999..., both inclusive, representing the seconds and fractional seconds in the localized value of $arg. Note that the value can be greater than 60 seconds to accommodate occasional leap seconds used to keep human time synchronized with the rotation of the planet.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(32, 3));
    public static final FunctionSignature fnTimezoneFromDateTime = new FunctionSignature(new QName("timezone-from-dateTime", "http://www.w3.org/2003/05/xpath-functions"), "Returns the timezone component of $arg if any. If $arg has a timezone component, then the result is an xdt:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(55, 3));

    public FunGetDateTimeComponent(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence arg = args[0];
        if (arg.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        DateTimeValue date = (DateTimeValue)arg.itemAt(0);
        if (this.isCalledAs("day-from-dateTime")) {
            return new IntegerValue(date.getPart(2), 31);
        }
        if (this.isCalledAs("month-from-dateTime")) {
            return new IntegerValue(date.getPart(1), 31);
        }
        if (this.isCalledAs("year-from-dateTime")) {
            return new IntegerValue(date.getPart(0), 31);
        }
        if (this.isCalledAs("hours-from-dateTime")) {
            return new IntegerValue(date.getPart(3), 31);
        }
        if (this.isCalledAs("minutes-from-dateTime")) {
            return new IntegerValue(date.getPart(4), 31);
        }
        if (this.isCalledAs("seconds-from-dateTime")) {
            long millis = date.getPart(5) * 1000 + date.getPart(6);
            return new DecimalValue(millis / 1000L);
        }
        long tzoffset = date.getTimezoneOffset();
        return new DayTimeDurationValue(tzoffset);
    }
}

