/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunGetDateComponent
extends Function {
    public static final FunctionSignature fnGetDayFromDate = new FunctionSignature(new QName("day-from-date", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $a.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnGetMonthFromDate = new FunctionSignature(new QName("month-from-date", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $a.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnGetYearFromDate = new FunctionSignature(new QName("year-from-date", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $a. The value may be negative.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnGetTimezoneFromDate = new FunctionSignature(new QName("timezone-from-date", "http://www.w3.org/2003/05/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $a. The value may be negative.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(55, 3));

    public FunGetDateComponent(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence arg = this.getArgument(0).eval(contextSequence, contextItem);
        if (arg.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        DateValue date = (DateValue)arg.itemAt(0);
        if (this.isCalledAs("day-from-date")) {
            return new IntegerValue(date.getPart(2), 31);
        }
        if (this.isCalledAs("month-from-date")) {
            return new IntegerValue(date.getPart(1), 31);
        }
        if (this.isCalledAs("timezone-from-date")) {
            long tzoffset = date.getTimezoneOffset();
            return new DayTimeDurationValue(tzoffset);
        }
        return new IntegerValue(date.getPart(0), 31);
    }
}

