/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunDoc
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("doc", "http://www.w3.org/2003/05/xpath-functions"), "Includes one or more documents into the input sequence. Currently, eXist interprets each argument as a path pointing to a document in the database, as for example, '/db/shakespeare/plays/hamlet.xml'. If the path is relative, it is resolved relative to the base URI property from the static context.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(-1, 3));
    private NodeProxy cachedNode = null;
    private String cachedPath = null;

    public FunDoc(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 1;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence arg = this.getArgument(0).eval(contextSequence, contextItem);
        if (arg.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String path = arg.itemAt(0).getStringValue();
        if (path.length() == 0) {
            throw new XPathException("Invalid argument to fn:doc function: empty string is not allowed here.");
        }
        if (path.charAt(0) != '/') {
            path = this.context.getBaseURI() + '/' + path;
        }
        Lock dlock = null;
        if (path.equals(this.cachedPath) && this.cachedNode != null) {
            dlock = this.cachedNode.getDocument().getUpdateLock();
            try {
                dlock.acquire(0);
                NodeProxy nodeProxy = this.cachedNode;
                return nodeProxy;
            }
            catch (LockException e) {
                throw new XPathException(this.getASTNode(), "Failed to acquire lock on document " + path);
            }
            finally {
                dlock.release(0);
            }
        }
        try {
            DocumentImpl doc = (DocumentImpl)this.context.getBroker().getDocument(path);
            if (doc == null) {
                Sequence sequence = Sequence.EMPTY_SEQUENCE;
                return sequence;
            }
            if (!doc.getPermissions().validate(this.context.getUser(), 4)) {
                throw new XPathException(this.getASTNode(), "Insufficient privileges to read resource " + path);
            }
            dlock = doc.getUpdateLock();
            dlock.acquire(0);
            this.cachedPath = path;
            NodeProxy nodeProxy = this.cachedNode = new NodeProxy(doc, -1L, 9);
            return nodeProxy;
        }
        catch (PermissionDeniedException e) {
            throw new XPathException("Permission denied: unable to load document " + path);
        }
        catch (LockException e) {
            throw new XPathException(this.getASTNode(), "Failed to acquire read lock on document " + path);
        }
        finally {
            if (dlock != null) {
                dlock.release(0);
            }
        }
    }

    public void resetState() {
        this.cachedNode = null;
        this.cachedPath = null;
    }
}

