/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.text.Collator;
import java.util.Comparator;
import java.util.TreeSet;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunDistinctValues
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("distinct-values", "http://www.w3.org/2003/05/xpath-functions"), new SequenceType[]{new SequenceType(20, 7)}, new SequenceType(20, 2));

    public FunDistinctValues(XQueryContext context) {
        super(context, signature);
    }

    public int returnsType() {
        return 20;
    }

    public int getDependencies() {
        int deps = 1;
        if (this.getArgumentCount() == 1) {
            deps |= this.getArgument(0).getDependencies();
        }
        return deps;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence values = this.getArgument(0).eval(contextSequence);
        TreeSet<AtomicValue> set = new TreeSet<AtomicValue>(new ValueComparator(this.context.getCollator(null)));
        ValueSequence result = new ValueSequence();
        SequenceIterator i = values.iterate();
        while (i.hasNext()) {
            AtomicValue value = (AtomicValue)i.nextItem();
            if (set.contains(value)) continue;
            set.add(value);
            result.add(value);
        }
        return result;
    }

    private static final class ValueComparator
    implements Comparator {
        Collator collator;

        public ValueComparator(Collator collator) {
            this.collator = collator;
        }

        public int compare(Object o1, Object o2) {
            try {
                return ((AtomicValue)o1).compareTo(this.collator, (AtomicValue)o2);
            }
            catch (XPathException e) {
                throw new IllegalArgumentException("cannot compare values");
            }
        }
    }
}

