/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FunDeepEqual
extends Function {
    public static final FunctionSignature signature;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FunDeepEqual(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 3;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence[] args = this.getArguments(contextSequence, contextItem);
        int length = args[0].getLength();
        if (length != args[1].getLength()) {
            return BooleanValue.FALSE;
        }
        for (int i = 0; i < length; ++i) {
            if (this.deepEquals(args[0].itemAt(i), args[1].itemAt(i))) continue;
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    private boolean deepEquals(Item a, Item b) {
        try {
            if (Type.subTypeOf(a.getType(), 20) || Type.subTypeOf(b.getType(), 20)) {
                if (!Type.subTypeOf(a.getType(), 20) || !Type.subTypeOf(b.getType(), 20)) {
                    return false;
                }
                return a.atomize().compareTo(this.context.getDefaultCollator(), b.atomize()) == 0;
            }
            if (!$assertionsDisabled && !Type.subTypeOf(a.getType(), -1)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !Type.subTypeOf(b.getType(), -1)) {
                throw new AssertionError();
            }
            if (a.getType() != b.getType()) {
                return false;
            }
            NodeValue nva = (NodeValue)a;
            NodeValue nvb = (NodeValue)b;
            if (nva.equals(nvb)) {
                return true;
            }
            switch (a.getType()) {
                case 6: {
                    Node na = nva instanceof Node ? (Node)((Object)nva) : ((NodeProxy)nva).getDocument();
                    Node nb = nvb instanceof Node ? (Node)((Object)nvb) : ((NodeProxy)nvb).getDocument();
                    return this.compareContents(na, nb);
                }
                case 1: {
                    Node na = nva.getNode();
                    Node nb = nvb.getNode();
                    return this.compareElements(na, nb);
                }
                case 2: {
                    Node na = nva.getNode();
                    Node nb = nvb.getNode();
                    return this.compareNames(na, nb) && this.safeEquals(na.getNodeValue(), nb.getNodeValue());
                }
                case 4: 
                case 500: {
                    Node na = nva.getNode();
                    Node nb = nvb.getNode();
                    return this.safeEquals(na.getNodeName(), nb.getNodeName()) && this.safeEquals(nva.getStringValue(), nvb.getStringValue());
                }
                case 3: 
                case 5: {
                    return this.safeEquals(nva.getStringValue(), nvb.getStringValue());
                }
            }
            throw new RuntimeException("unexpected item type " + Type.getTypeName(a.getType()));
        }
        catch (XPathException e) {
            return false;
        }
    }

    private boolean compareElements(Node a, Node b) {
        return this.compareNames(a, b) && this.compareAttributes(a, b) && this.compareContents(a, b);
    }

    private boolean compareContents(Node a, Node b) {
        a = this.findNextTextOrElementNode(a.getFirstChild());
        b = this.findNextTextOrElementNode(b.getFirstChild());
        while (a != null && b != null) {
            if (a.getNodeType() != b.getNodeType()) {
                return false;
            }
            switch (a.getNodeType()) {
                case 3: {
                    if (this.safeEquals(a.getNodeValue(), b.getNodeValue())) break;
                    return false;
                }
                case 1: {
                    if (this.compareElements(a, b)) break;
                    return false;
                }
                default: {
                    throw new RuntimeException("unexpected node type " + a.getNodeType());
                }
            }
            a = this.findNextTextOrElementNode(a.getNextSibling());
            b = this.findNextTextOrElementNode(b.getNextSibling());
        }
        return a == b;
    }

    private Node findNextTextOrElementNode(Node n) {
        while (n != null && n.getNodeType() != 1 && n.getNodeType() != 3) {
            n = n.getNextSibling();
        }
        return n;
    }

    private boolean compareAttributes(Node a, Node b) {
        NamedNodeMap nnma = a.getAttributes();
        NamedNodeMap nnmb = b.getAttributes();
        if (nnma.getLength() != nnmb.getLength()) {
            return false;
        }
        for (int i = 0; i < nnma.getLength(); ++i) {
            Node tb;
            Node ta = nnma.item(i);
            Node node = tb = ta.getLocalName() == null ? nnmb.getNamedItem(ta.getNodeName()) : nnmb.getNamedItemNS(ta.getNamespaceURI(), ta.getLocalName());
            if (tb != null && this.safeEquals(ta.getNodeValue(), tb.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private boolean compareNames(Node a, Node b) {
        if (a.getLocalName() != null || b.getLocalName() != null) {
            return this.safeEquals(a.getNamespaceURI(), b.getNamespaceURI()) && this.safeEquals(a.getLocalName(), b.getLocalName());
        }
        return this.safeEquals(a.getNodeName(), b.getNodeName());
    }

    private boolean safeEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    static {
        $assertionsDisabled = !FunDeepEqual.class.desiredAssertionStatus();
        signature = new FunctionSignature(new QName("deep-equal", "http://www.w3.org/2003/05/xpath-functions"), new SequenceType[]{new SequenceType(11, 7), new SequenceType(11, 7)}, new SequenceType(23, 2));
    }
}

