/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.TimeZone;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.TimeValue;

public class FunAdjustTimeToTimezone
extends BasicFunction {
    public static final FunctionSignature[] fnAdjustTimeToTimezone = new FunctionSignature[]{new FunctionSignature(new QName("adjust-time-to-timezone", "http://www.w3.org/2003/05/xpath-functions"), "Adjusts an xs:time value to the implicit timezone of the current locale.", new SequenceType[]{new SequenceType(52, 3)}, new SequenceType(52, 3)), new FunctionSignature(new QName("adjust-time-to-timezone", "http://www.w3.org/2003/05/xpath-functions"), "Adjusts an xs:time value to a specific timezone, or to no timezone at all. If $b is the empty sequence, returns an xs:time without a timezone.", new SequenceType[]{new SequenceType(52, 3), new SequenceType(55, 3)}, new SequenceType(52, 3))};

    public FunAdjustTimeToTimezone(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        int tzOffset;
        if (args[0].getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        TimeValue time = (TimeValue)args[0].itemAt(0);
        if (this.getSignature().getArgumentCount() == 2) {
            if (args[1].getLength() == 0) {
                tzOffset = 0;
            } else {
                DayTimeDurationValue duration = (DayTimeDurationValue)args[1].itemAt(0);
                tzOffset = (int)(duration.getValueInMilliseconds() / 60000L);
            }
        } else {
            TimeZone zone = TimeZone.getDefault();
            tzOffset = zone.getRawOffset() / 60000;
        }
        return time.adjustToTimezone(tzOffset);
    }
}

