/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import org.exist.EXistException;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.analysis.Tokenizer;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtFulltext
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("contains", "http://www.w3.org/2003/05/xpath-functions"), new SequenceType[]{new SequenceType(-1, 7)}, new SequenceType(-1, 7));
    protected PathExpr path;
    protected Expression searchTerm = null;
    protected String[] terms = null;
    protected int type = 1;
    protected CachedResult cached = null;

    public ExtFulltext(XQueryContext context, int type) {
        super(context, signature);
        this.type = type;
    }

    public ExtFulltext(XQueryContext context, PathExpr path) {
        super(context, signature);
        this.path = path;
    }

    public void addTerm(Expression term) {
        if (term instanceof PathExpr && ((PathExpr)term).getLength() == 1) {
            term = ((PathExpr)term).getExpression(0);
        }
        this.searchTerm = term;
    }

    protected void getSearchTerms(XQueryContext context, String searchString) throws EXistException {
        TextToken token;
        ArrayList<String> tokens = new ArrayList<String>();
        Tokenizer tokenizer = context.getBroker().getTextEngine().getTokenizer();
        tokenizer.setText(searchString);
        while (null != (token = tokenizer.nextToken(true))) {
            String word = token.getText();
            tokens.add(word);
        }
        this.terms = new String[tokens.size()];
        this.terms = tokens.toArray(this.terms);
    }

    public int countTerms() {
        return this.terms.length;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        NodeSet result = null;
        if (this.path == null || (this.path.getDependencies() & 2) == 0) {
            boolean canCache;
            boolean bl = canCache = (this.searchTerm.getDependencies() & 2) == 0;
            if (canCache && this.cached != null && this.cached.isValid(contextSequence)) {
                return this.cached.getResult();
            }
            NodeSet nodes = this.path == null ? contextSequence.toNodeSet() : this.path.eval(contextSequence).toNodeSet();
            String arg = this.searchTerm.eval(contextSequence).getStringValue();
            result = this.evalQuery(arg, nodes).toNodeSet();
            if (canCache && contextSequence instanceof NodeSet) {
                this.cached = new CachedResult((NodeSet)contextSequence, result);
            }
        } else {
            NodeSet nodes = null;
            result = new ExtArrayNodeSet();
            SequenceIterator i = contextSequence.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                String arg = this.searchTerm.eval(current.toSequence()).getStringValue();
                nodes = this.path == null ? contextSequence.toNodeSet() : this.path.eval(current.toSequence()).toNodeSet();
                Sequence temp = this.evalQuery(arg, nodes);
                result.addAll(temp);
            }
        }
        return result;
    }

    public Sequence evalQuery(String searchArg, NodeSet nodes) throws XPathException {
        try {
            this.getSearchTerms(this.context, searchArg);
        }
        catch (EXistException e) {
            throw new XPathException(e.getMessage(), e);
        }
        NodeSet hits = this.processQuery(nodes);
        if (hits == null) {
            return NodeSet.EMPTY_SET;
        }
        return hits;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.path.pprint());
        buf.append(" &= \"");
        buf.append(this.searchTerm.pprint());
        buf.append("\")");
        return buf.toString();
    }

    public int getDependencies() {
        return this.path.getDependencies();
    }

    public DocumentSet preselect(DocumentSet in_docs) {
        return in_docs;
    }

    protected NodeSet processQuery(NodeSet contextSet) throws XPathException {
        if (this.terms == null) {
            throw new RuntimeException("no search terms");
        }
        if (this.terms.length == 0) {
            return NodeSet.EMPTY_SET;
        }
        NodeSet[] hits = new NodeSet[this.terms.length];
        for (int k = 0; k < this.terms.length; ++k) {
            hits[k] = this.context.getBroker().getTextEngine().getNodesContaining(this.context, contextSet.getDocumentSet(), contextSet, this.terms[k]);
        }
        NodeSet result = hits[0];
        if (result != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                result = this.type == 1 ? result.deepIntersection(hits[k]) : result.union(hits[k]);
            }
            return result;
        }
        return NodeSet.EMPTY_SET;
    }

    public int returnsType() {
        return -1;
    }

    public void setPath(PathExpr path) {
        this.path = path;
    }

    public void setInPredicate(boolean inPredicate) {
        if (this.path != null) {
            this.path.setInPredicate(inPredicate);
        }
    }

    public void resetState() {
        this.path.resetState();
        this.searchTerm.resetState();
        this.cached = null;
    }
}

