/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.util.LockException;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtDocument
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("document", "http://www.w3.org/2003/05/xpath-functions"), "Includes one or more documents into the input sequence. This function is specific to eXist and will be replaced with the corresponding fn:doc function. Currently, eXist interprets each argument as an absolute path pointing to a document in the database, as for example, '/db/shakespeare/plays/hamlet.xml'. If no arguments are specified, the function will load all documents in the database.", new SequenceType[]{new SequenceType(22, 6)}, new SequenceType(-1, 7), true);
    private List cachedArgs = null;
    private Sequence cached = null;

    public ExtDocument(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 1;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        DocumentSet docs = null;
        Sequence result = null;
        if (this.getArgumentCount() == 0) {
            if (this.cached != null) {
                result = this.cached;
                docs = this.cached.getDocumentSet();
            } else {
                docs = new DocumentSet();
                this.context.getBroker().getAllDocuments(docs);
            }
        } else {
            List args = this.getParameterValues(contextSequence, contextItem);
            boolean cacheIsValid = false;
            if (this.cachedArgs != null) {
                cacheIsValid = this.compareArguments(this.cachedArgs, args);
            }
            if (cacheIsValid) {
                result = this.cached;
                docs = this.cached.getDocumentSet();
            } else {
                docs = new DocumentSet();
                for (int i = 0; i < args.size(); ++i) {
                    String next = (String)args.get(i);
                    if (next.length() == 0) {
                        throw new XPathException("Invalid argument to fn:doc function: empty string is not allowed here.");
                    }
                    if (next.charAt(0) != '/') {
                        next = this.context.getBaseURI() + '/' + next;
                    }
                    try {
                        DocumentImpl doc = (DocumentImpl)this.context.getBroker().getDocument(next);
                        if (doc == null) continue;
                        if (!doc.getPermissions().validate(this.context.getUser(), 4)) {
                            throw new XPathException("Insufficient privileges to read resource " + next);
                        }
                        docs.add(doc);
                        continue;
                    }
                    catch (PermissionDeniedException e) {
                        throw new XPathException("Permission denied: unable to load document " + next);
                    }
                }
                this.cachedArgs = args;
            }
        }
        try {
            docs.lock(false);
            if (result == null) {
                result = new ExtArrayNodeSet(docs.getLength(), 1);
                Iterator i = docs.iterator();
                while (i.hasNext()) {
                    result.add(new NodeProxy((DocumentImpl)i.next(), -1L, 9));
                }
            }
        }
        catch (LockException e) {
            throw new XPathException(this.getASTNode(), "Could not acquire lock on document set.");
        }
        finally {
            docs.unlock(false);
        }
        this.cached = result;
        return result;
    }

    private List getParameterValues(Sequence contextSequence, Item contextItem) throws XPathException {
        ArrayList<String> args = new ArrayList<String>(this.getArgumentCount() + 10);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                Item next = j.nextItem();
                args.add(next.getStringValue());
            }
        }
        return args;
    }

    private boolean compareArguments(List args1, List args2) {
        if (args1.size() != args2.size()) {
            return false;
        }
        for (int i = 0; i < args1.size(); ++i) {
            String arg2;
            String arg1 = (String)args1.get(i);
            if (arg1.equals(arg2 = (String)args2.get(i))) continue;
            return false;
        }
        return true;
    }

    public void resetState() {
        this.cached = null;
        this.cachedArgs = null;
    }
}

