/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.memtree.MemTreeBuilder;
import org.exist.util.Configuration;
import org.exist.xquery.Expression;
import org.exist.xquery.Pragma;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;

public class XQueryWatchDog {
    private static final Logger LOG = Logger.getLogger((Class)XQueryWatchDog.class);
    private XQueryContext context;
    private long timeout = Long.MAX_VALUE;
    private int maxNodesLimit = Integer.MAX_VALUE;
    private long startTime;
    private boolean terminate = false;
    private List tempFragments = null;

    public XQueryWatchDog(XQueryContext context) {
        this.context = context;
        this.configureDefaults();
        this.startTime = System.currentTimeMillis();
    }

    private void configureDefaults() {
        Configuration conf = this.context.broker.getBrokerPool().getConfiguration();
        Object option = conf.getProperty("db-connection.watchdog.query-timeout");
        if (option != null) {
            this.timeout = (Long)option;
        }
        if (this.timeout <= 0L) {
            this.timeout = Long.MAX_VALUE;
        }
        if ((option = conf.getProperty("db-connection.watchdog.output-size-limit")) != null) {
            this.maxNodesLimit = (Integer)option;
        }
    }

    public void setTimeoutFromPragma(Pragma pragma) throws XPathException {
        String[] contents = pragma.tokenizeContents();
        if (contents.length != 1) {
            throw new XPathException("Pragma 'timeout' should have exactly one parameter: the timeout value.");
        }
        try {
            this.timeout = Long.parseLong(contents[0]);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Error parsing timeout value in pragma " + pragma.getQName().toString());
        }
        LOG.debug((Object)("timeout set from pragma: " + this.timeout + "ms."));
    }

    public void setMaxNodesFromPragma(Pragma pragma) throws XPathException {
        String[] contents = pragma.tokenizeContents();
        if (contents.length != 1) {
            throw new XPathException("Pragma 'output-size-limit' should have exactly one parameter: the timeout value.");
        }
        try {
            this.maxNodesLimit = Integer.parseInt(contents[0]);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Error parsing size-limit value in pragma " + pragma.getQName().toString());
        }
        LOG.debug((Object)("output-size-limit set from pragma: " + this.maxNodesLimit));
    }

    public void proceed(Expression expr) throws TerminatedException {
        if (this.terminate) {
            if (expr == null) {
                expr = this.context.getRootExpression();
            }
            this.cleanUp();
            throw new TerminatedException(expr.getASTNode(), "The query has been killed by the server.");
        }
        long elapsed = System.currentTimeMillis() - this.startTime;
        if (elapsed > this.timeout) {
            if (expr == null) {
                expr = this.context.getRootExpression();
            }
            LOG.warn((Object)("Query exceeded predefined timeout (" + elapsed + "ms.): " + expr.pprint()));
            this.cleanUp();
            throw new TerminatedException.TimeoutException(expr.getASTNode(), "The query exceeded the predefined timeout and has been killed.");
        }
    }

    public void proceed(Expression expr, MemTreeBuilder builder) throws TerminatedException {
        this.proceed(expr);
        if (builder.getSize() > this.maxNodesLimit) {
            if (expr == null) {
                expr = this.context.getRootExpression();
            }
            LOG.warn((Object)("Query exceeded predefined limit for document fragments: " + expr.pprint()));
            this.cleanUp();
            throw new TerminatedException.SizeLimitException(expr.getASTNode(), "The constructed document fragment exceeded the predefined size limit (current: " + builder.getSize() + "; allowed: " + this.maxNodesLimit + "). The query has been killed.");
        }
    }

    public void addTemporaryFragment(String docName) {
        if (this.tempFragments == null) {
            this.tempFragments = new LinkedList();
        }
        this.tempFragments.add(docName);
    }

    public void cleanUp() {
        if (this.tempFragments == null) {
            return;
        }
        this.context.getBroker().removeTempDocs(this.tempFragments);
        this.tempFragments = null;
    }

    public void kill(long waitTime) {
        this.terminate = true;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.terminate = false;
    }
}

