/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.parser.XQueryAST;

public class XPathException
extends Exception {
    private int line = 0;
    private int column = 0;
    private String message = null;

    public XPathException() {
    }

    public XPathException(String message) {
        this.message = message;
    }

    public XPathException(XQueryAST ast, String message) {
        this.message = message;
        this.setASTNode(ast);
    }

    public XPathException(String message, int line, int column) {
        this.message = message;
        this.line = line;
        this.column = column;
    }

    public XPathException(Throwable cause) {
        super(cause);
    }

    public XPathException(String message, Throwable cause) {
        super(cause);
        this.message = message;
    }

    public XPathException(XQueryAST ast, String message, Throwable cause) {
        super(cause);
        this.message = message;
        this.setASTNode(ast);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setASTNode(XQueryAST ast) {
        if (ast != null) {
            this.line = ast.getLine();
            this.column = ast.getColumn();
        }
    }

    public void prependMessage(String msg) {
        StringBuffer buf = new StringBuffer();
        buf.append(msg);
        if (this.message != null && this.message.length() > 0) {
            buf.append(": \n");
        }
        buf.append(this.message);
        this.message = buf.toString();
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = "";
        }
        if (this.line == 0) {
            return this.message;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.message);
        buf.append(" [at line ");
        buf.append(this.getLine());
        buf.append(", column ");
        buf.append(this.getColumn());
        buf.append("]");
        return buf.toString();
    }
}

