/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class VariableReference
extends AbstractExpression {
    private String qname;

    public VariableReference(XQueryContext context, String qname) {
        super(context);
        this.qname = qname;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            Sequence seq = var.getValue();
            return seq;
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw e;
        }
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public String pprint() {
        return "$" + this.qname;
    }

    public int returnsType() {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            if (var != null && var.getValue() != null) {
                int type = var.getValue().getItemType();
                return type;
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return 11;
    }

    public int getDependencies() {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            if (var != null && var.getValue() != null) {
                int deps = var.getDependencies(this.context);
                return deps;
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return 3;
    }

    public int getCardinality() {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            if (var != null && var.getValue() != null) {
                int card = var.getValue().getCardinality();
                return card;
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return 7;
    }

    public Variable getVariable() {
        try {
            Variable var = this.context.resolveVariable(this.qname);
            return var;
        }
        catch (XPathException e) {
            return null;
        }
    }

    public void resetState() {
    }
}

