/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.text.Collator;
import java.util.Iterator;
import org.exist.dom.ContextItem;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.xquery.Expression;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class ValueComparison
extends GeneralComparison {
    public ValueComparison(XQueryContext context, int relation) {
        super(context, relation);
    }

    public ValueComparison(XQueryContext context, Expression left, Expression right, int relation) {
        super(context, left, right, relation);
    }

    protected Sequence genericCompare(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        if (ls.getLength() == 0 || rs.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Collator collator = this.getCollator(contextSequence);
        if (ls.getLength() == 1 && rs.getLength() == 1) {
            AtomicValue lv = ls.itemAt(0).atomize();
            AtomicValue rv = rs.itemAt(0).atomize();
            return BooleanValue.valueOf(this.compareValues(collator, lv, rv));
        }
        throw new XPathException("Type error: sequence with less or more than one item is not allowed here");
    }

    protected Sequence nodeSetCompare(NodeSet nodes, Sequence contextSequence) throws XPathException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Collator collator = this.getCollator(contextSequence);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            NodeProxy current = (NodeProxy)i.next();
            ContextItem c = current.getContext();
            do {
                AtomicValue lv = current.atomize();
                Sequence rs = this.getRight().eval(c.getNode().toSequence());
                if (rs.getLength() != 1) {
                    throw new XPathException("Type error: sequence with less or more than one item is not allowed here");
                }
                if (!this.compareValues(collator, lv, rs.itemAt(0).atomize())) continue;
                result.add(current);
            } while ((c = c.getNextItem()) != null);
        }
        return result;
    }
}

