/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class UntypedValueCheck
extends AbstractExpression {
    private Expression expression;
    private int requiredType;

    public UntypedValueCheck(XQueryContext context, int requiredType, Expression expression) {
        super(context);
        this.requiredType = requiredType;
        this.expression = expression;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        ValueSequence result = new ValueSequence();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            try {
                result.add(item.convertTo(this.requiredType));
            }
            catch (XPathException e) {
                e.setASTNode(this.expression.getASTNode());
                throw e;
            }
        }
        return result;
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public String pprint() {
        return this.expression.pprint() + " cast as " + Type.getTypeName(this.requiredType);
    }

    public int returnsType() {
        return this.requiredType;
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void resetState() {
        this.expression.resetState();
    }

    public XQueryAST getASTNode() {
        return this.expression.getASTNode();
    }
}

