/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Constants;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class Step
extends AbstractExpression {
    protected static final Logger LOG = Logger.getLogger((Class)Step.class);
    protected int axis = -1;
    protected ArrayList predicates = new ArrayList();
    protected NodeTest test;
    protected boolean inPredicate = false;

    public Step(XQueryContext context, int axis) {
        super(context);
        this.axis = axis;
    }

    public Step(XQueryContext context, int axis, NodeTest test) {
        this(context, axis);
        this.test = test;
    }

    public void addPredicate(Expression expr) {
        this.predicates.add(expr);
    }

    public abstract Sequence eval(Sequence var1, Item var2) throws XPathException;

    public int getAxis() {
        return this.axis;
    }

    public void setPrimaryAxis(int axis) {
        this.axis = axis;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        if (this.axis > -1) {
            buf.append(Constants.AXISSPECIFIERS[this.axis]);
        }
        buf.append("::");
        if (this.test != null) {
            buf.append(this.test.toString());
        } else {
            buf.append("*");
        }
        if (this.predicates.size() > 0) {
            Iterator i = this.predicates.iterator();
            while (i.hasNext()) {
                buf.append('[');
                buf.append(((Predicate)i.next()).pprint());
                buf.append(']');
            }
        }
        return buf.toString();
    }

    public int returnsType() {
        return -1;
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public void setTest(NodeTest test) {
        this.test = test;
    }

    public void setInPredicate(boolean inPredicate) {
        this.inPredicate = inPredicate;
    }

    public void resetState() {
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            pred.resetState();
        }
    }
}

