/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.NodeSet;
import org.exist.xquery.Expression;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class SimpleStep
extends Step {
    private Expression expression;

    public SimpleStep(XQueryContext context, int axis, Expression expression) {
        super(context, axis);
        this.expression = expression;
        this.expression.setPrimaryAxis(axis);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet set;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((set = this.expression.eval(contextSequence).toNodeSet()).getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        switch (this.axis) {
            case 8: {
                set = set.selectAncestorDescendant(contextSequence.toNodeSet(), 1, true, this.inPredicate);
                break;
            }
            case 5: {
                set = set.selectParentChild(contextSequence.toNodeSet(), 1, this.inPredicate);
                break;
            }
            default: {
                throw new XPathException("Wrong axis specified");
            }
        }
        return set;
    }

    public String pprint() {
        return "simple: " + (this.axis == 8 ? "//" + this.expression.pprint() : '/' + this.expression.pprint());
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
    }

    public void setInPredicate(boolean inPredicate) {
        super.setInPredicate(inPredicate);
        this.expression.setInPredicate(inPredicate);
    }

    public void setPrimaryAxis(int axis) {
        this.expression.setPrimaryAxis(axis);
    }
}

