/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.ArraySet;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.util.LockException;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class RootNode
extends Step {
    private Sequence cached = null;
    private DocumentSet cachedDocs = null;

    public RootNode(XQueryContext context) {
        super(context, 12);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        DocumentSet ds = this.context.getStaticallyKnownDocuments();
        if (ds == null || ds.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            ds.lock(false);
            if (this.cachedDocs != null && this.cachedDocs.equals(ds)) {
                Sequence sequence = this.cached;
                return sequence;
            }
            ArraySet result = new ArraySet(ds.getLength());
            Iterator i = ds.iterator();
            while (i.hasNext()) {
                DocumentImpl d = (DocumentImpl)i.next();
                if (d.getResourceType() != 0) continue;
                result.add(new NodeProxy(d, -1L));
            }
            this.cached = result;
            this.cachedDocs = ds;
            ArraySet arraySet = result;
            return arraySet;
        }
        catch (LockException e) {
            throw new XPathException(this.getASTNode(), "Failed to acquire lock on the context document set");
        }
        finally {
            ds.unlock(false);
        }
    }

    public String pprint() {
        return "ROOT";
    }

    public int returnsType() {
        return -1;
    }

    public void resetState() {
        this.cachedDocs = null;
        this.cached = null;
    }
}

