/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class QuantifiedExpression
extends BindingExpression {
    public static final int SOME = 0;
    public static final int EVERY = 1;
    private int mode = 0;

    public QuantifiedExpression(XQueryContext context, int mode) {
        super(context);
        this.mode = mode;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem, Sequence resultSequence) throws XPathException {
        LocalVariable mark = this.context.markLocalVariables();
        LocalVariable var = new LocalVariable(QName.parse(this.context, this.varName, null));
        this.context.declareVariable(var);
        Sequence inSeq = this.inputSequence.eval(null);
        boolean found = false;
        SequenceIterator i = inSeq.iterate();
        while (i.hasNext()) {
            contextItem = i.nextItem();
            if (this.sequenceType != null) {
                this.sequenceType.checkType(contextItem.getType());
            }
            var.setValue(contextItem.toSequence());
            Sequence satisfiesSeq = this.returnExpr.eval(null);
            if (this.returnExpr.returnsType() == 23) {
                found = satisfiesSeq.effectiveBooleanValue();
            } else {
                boolean bl = found = satisfiesSeq.getLength() != 0;
            }
            if ((this.mode != 0 || !found) && (this.mode != 1 || found)) continue;
        }
        this.context.popLocalVariables(mark);
        return found ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("some $");
        buf.append(this.varName);
        buf.append(" in ");
        buf.append(this.inputSequence.pprint());
        buf.append(" satisfies ");
        buf.append(this.returnExpr.pprint());
        return buf.toString();
    }

    public int returnsType() {
        return 23;
    }

    public int getDependencies() {
        return 3;
    }
}

