/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.ArraySet;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.VirtualNodeSet;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Predicate
extends PathExpr {
    protected CachedResult cached = null;

    public Predicate(XQueryContext context) {
        super(context);
    }

    public int getDependencies() {
        if (this.getLength() == 1) {
            this.getExpression(0).setInPredicate(true);
            return this.getExpression(0).getDependencies();
        }
        return super.getDependencies();
    }

    public Sequence evalPredicate(Sequence outerSequence, Sequence contextSequence, int mode) throws XPathException {
        this.setInPredicate(true);
        Expression inner = this.getExpression(0);
        if (inner == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        int type = inner.returnsType();
        if (Type.subTypeOf(type, -1)) {
            if ((inner.getDependencies() & 2) == 0) {
                return this.selectByNodeSet(contextSequence);
            }
            return this.evalBoolean(contextSequence, inner);
        }
        if (Type.subTypeOf(type, 30)) {
            return this.selectByPosition(outerSequence, contextSequence, mode, inner);
        }
        return this.evalBoolean(contextSequence, inner);
    }

    private Sequence evalBoolean(Sequence contextSequence, Expression inner) throws XPathException {
        ValueSequence result = new ValueSequence();
        int p = 0;
        this.context.setContextPosition(0);
        SequenceIterator i = contextSequence.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            this.context.setContextPosition(p);
            Sequence innerSeq = inner.eval(contextSequence, item);
            if (innerSeq.effectiveBooleanValue()) {
                result.add(item);
            }
            ++p;
        }
        return result;
    }

    private Sequence selectByNodeSet(Sequence contextSequence) throws XPathException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSet contextSet = contextSequence.toNodeSet();
        boolean contextIsVirtual = contextSet instanceof VirtualNodeSet;
        NodeSet nodes = super.eval(contextSequence, null).toNodeSet();
        if (this.cached != null && this.cached.isValid(contextSequence) && nodes.isCached()) {
            return this.cached.getResult();
        }
        DocumentImpl lastDoc = null;
        int count = 0;
        int sizeHint = -1;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            ContextItem contextNode;
            NodeProxy current = (NodeProxy)i.next();
            if (lastDoc == null || current.getDocument() != lastDoc) {
                lastDoc = current.getDocument();
                sizeHint = nodes.getSizeHint(lastDoc);
            }
            if ((contextNode = current.getContext()) == null) {
                throw new XPathException("Internal evaluation error: context node is missing for node " + current.gid + "!");
            }
            while (contextNode != null) {
                NodeProxy next = contextNode.getNode();
                if (contextIsVirtual || contextSet.contains(next)) {
                    next.addMatches(current);
                    result.add(next, sizeHint);
                }
                contextNode = contextNode.getNextItem();
            }
            ++count;
        }
        if (contextSequence instanceof NodeSet) {
            this.cached = new CachedResult((NodeSet)contextSequence, result);
        }
        return result;
    }

    private Sequence selectByPosition(Sequence outerSequence, Sequence contextSequence, int mode, Expression inner) throws XPathException {
        if (Type.subTypeOf(contextSequence.getItemType(), -1) && outerSequence != null && outerSequence.getLength() > 0) {
            ArraySet result = new ArraySet(100);
            NodeSet contextSet = contextSequence.toNodeSet();
            boolean reverseAxis = Predicate.isReverseAxis(mode);
            if (!reverseAxis && mode != 10 && mode != 12) {
                NodeSet ancestors = contextSet.selectAncestorDescendant(outerSequence.toNodeSet(), 0, true, true);
                SequenceIterator i = ancestors.iterate();
                while (i.hasNext()) {
                    Item item = i.nextItem();
                    NodeProxy p = (NodeProxy)item;
                    Sequence innerSeq = inner.eval(contextSequence);
                    SequenceIterator j = innerSeq.iterate();
                    while (j.hasNext()) {
                        Item next = j.nextItem();
                        NumericValue v = (NumericValue)next.convertTo(30);
                        int count = 0;
                        for (ContextItem contextNode = p.getContext(); contextNode != null; contextNode = contextNode.getNextItem()) {
                            if (++count != v.getInt()) continue;
                            result.add((Item)contextNode.getNode());
                        }
                    }
                }
            } else {
                SequenceIterator i = outerSequence.iterate();
                while (i.hasNext()) {
                    NodeSet temp;
                    Item item = i.nextItem();
                    NodeProxy p = (NodeProxy)item;
                    switch (mode) {
                        case 10: {
                            temp = contextSet.selectSiblings(p, 3);
                            break;
                        }
                        case 4: {
                            temp = contextSet.selectSiblings(p, 2);
                            break;
                        }
                        case 2: {
                            temp = p.getParents(false);
                            break;
                        }
                        case 0: 
                        case 1: {
                            temp = contextSet.selectAncestors(p, false, false);
                            break;
                        }
                        case 12: {
                            temp = p;
                            break;
                        }
                        default: {
                            temp = contextSet.selectAncestorDescendant(p, 1);
                        }
                    }
                    Sequence innerSeq = inner.eval(contextSequence);
                    SequenceIterator j = innerSeq.iterate();
                    while (j.hasNext()) {
                        Item next = j.nextItem();
                        NumericValue v = (NumericValue)next.convertTo(30);
                        int pos = reverseAxis ? temp.getLength() - v.getInt() : v.getInt() - 1;
                        if (pos >= temp.getLength() || pos <= -1) continue;
                        result.add(temp.itemAt(pos));
                    }
                }
            }
            return result;
        }
        Sequence innerSeq = inner.eval(contextSequence);
        ValueSequence result = new ValueSequence();
        SequenceIterator i = innerSeq.iterate();
        while (i.hasNext()) {
            NumericValue v = (NumericValue)i.nextItem().convertTo(30);
            int pos = v.getInt() - 1;
            if (pos >= contextSequence.getLength() || pos <= -1) continue;
            result.add(contextSequence.itemAt(pos));
        }
        return result;
    }

    public static final boolean isReverseAxis(int axis) {
        return axis < 5;
    }

    public void resetState() {
        super.resetState();
        this.cached = null;
    }
}

