/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.NodeSet;
import org.exist.xquery.Expression;
import org.exist.xquery.LogicalOp;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class OpAnd
extends LogicalOp {
    public OpAnd(XQueryContext context) {
        super(context);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Expression left = this.getLeft();
        Expression right = this.getRight();
        if (Type.subTypeOf(left.returnsType(), -1) && Type.subTypeOf(right.returnsType(), -1) && (left.getDependencies() & 2) == 0 && (right.getDependencies() & 2) == 0) {
            NodeSet rl = left.eval(contextSequence, null).toNodeSet();
            rl = rl.getContextNodes(this.inPredicate);
            NodeSet rr = right.eval(contextSequence, null).toNodeSet();
            rr = rr.getContextNodes(this.inPredicate);
            rl = rr.intersection(rl);
            return rl;
        }
        boolean ls = left.eval(contextSequence).effectiveBooleanValue();
        boolean rs = right.eval(contextSequence).effectiveBooleanValue();
        return ls && rs ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public String pprint() {
        if (this.getLength() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getExpression(0).pprint());
        for (int i = 1; i < this.getLength(); ++i) {
            buf.append(" and ");
            buf.append(this.getExpression(i).pprint());
        }
        return buf.toString();
    }
}

