/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.BinaryOp;
import org.exist.xquery.Constants;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;

public class NodeComparison
extends BinaryOp {
    private int relation;

    public NodeComparison(XQueryContext context, Expression left, Expression right, int relation) {
        super(context);
        this.relation = relation;
        this.add(new DynamicCardinalityCheck(context, 2, left));
        this.add(new DynamicCardinalityCheck(context, 2, right));
    }

    public int getDependencies() {
        return 3;
    }

    public int getCardinality() {
        return 3;
    }

    public int returnsType() {
        return 23;
    }

    /*
     * WARNING - void declaration
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        void var7_7;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        if (ls.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (rs.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeValue sv = (NodeValue)ls.itemAt(0);
        NodeValue rv = (NodeValue)rs.itemAt(0);
        if (sv.getImplementationType() != rv.getImplementationType()) {
            return BooleanValue.FALSE;
        }
        switch (this.relation) {
            case 14: {
                BooleanValue result = sv.equals(rv) ? BooleanValue.TRUE : BooleanValue.FALSE;
                break;
            }
            case 15: {
                BooleanValue result = sv.equals(rv) ? BooleanValue.FALSE : BooleanValue.TRUE;
                break;
            }
            case 16: {
                BooleanValue result = sv.before(rv) ? BooleanValue.TRUE : BooleanValue.FALSE;
                break;
            }
            case 17: {
                BooleanValue result = sv.after(rv) ? BooleanValue.TRUE : BooleanValue.FALSE;
                break;
            }
            default: {
                throw new XPathException("Illegal argument: unknown relation");
            }
        }
        return var7_7;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getLeft().pprint()).append(' ').append(Constants.OPS[this.relation]);
        buf.append(' ').append(this.getRight().pprint());
        return buf.toString();
    }
}

