/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.Atomize;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class NamespaceConstructor
extends NodeConstructor {
    private String prefix = null;
    private Expression uri = null;

    public NamespaceConstructor(XQueryContext context, String prefix) {
        super(context);
        this.prefix = prefix;
    }

    public void setURIExpression(Expression uriExpr) {
        this.uri = new Atomize(this.context, uriExpr);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        Sequence uriSeq = this.uri.eval(contextSequence, contextItem);
        String value = null;
        if (uriSeq.getLength() == 0) {
            value = "";
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = uriSeq.iterate();
            while (i.hasNext()) {
                this.context.proceed(this, builder);
                Item next = i.nextItem();
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(next.toString());
            }
            value = buf.toString();
        }
        this.context.declareInScopeNamespace(this.prefix, value);
        int nodeNr = builder.namespaceNode(this.prefix, value);
        return builder.getDocument().getNamespaceNode(nodeNr);
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("namespace ").append(this.prefix);
        buf.append("{ ").append(this.uri.pprint()).append(" }");
        return buf.toString();
    }
}

