/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.ArraySet;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.VirtualNodeSet;
import org.exist.dom.XMLUtil;
import org.exist.xquery.CachedResult;
import org.exist.xquery.ChildSelector;
import org.exist.xquery.DescendantOrSelfSelector;
import org.exist.xquery.DescendantSelector;
import org.exist.xquery.NodeSelector;
import org.exist.xquery.NodeTest;
import org.exist.xquery.ParentSelector;
import org.exist.xquery.Predicate;
import org.exist.xquery.SelfSelector;
import org.exist.xquery.Step;
import org.exist.xquery.TypeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class LocationStep
extends Step {
    protected NodeSet currentSet = null;
    protected DocumentSet currentDocs = null;
    protected CachedResult cached = null;
    protected int parentDeps = -1;

    public LocationStep(XQueryContext context, int axis) {
        super(context, axis);
    }

    public LocationStep(XQueryContext context, int axis, NodeTest test) {
        super(context, axis, test);
    }

    public int getDependencies() {
        int deps = 1;
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            deps |= ((Predicate)i.next()).getDependencies();
        }
        return deps;
    }

    protected boolean preloadNodeSets() {
        return (this.getParentDependencies() & 4) == 4;
    }

    protected int getParentDependencies() {
        if (this.parentDeps < 0) {
            if (this.getParent() != null) {
                this.parentDeps = this.getParent().getDependencies();
            } else {
                LOG.warn((Object)("Parent for expression " + this.pprint() + " unknown"));
                this.parentDeps = 3;
            }
        }
        return this.parentDeps;
    }

    protected Sequence applyPredicate(Sequence outerSequence, Sequence contextSequence) throws XPathException {
        if (contextSequence == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Sequence result = contextSequence;
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            result = pred.evalPredicate(outerSequence, result, this.axis);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        void var3_3;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (contextSequence == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.cached != null && this.cached.isValid(contextSequence)) {
            return this.predicates.size() == 0 ? this.cached.getResult() : this.applyPredicate(contextSequence, this.cached.getResult());
        }
        switch (this.axis) {
            case 7: 
            case 8: {
                Sequence temp = this.getDescendants(this.context, contextSequence.toNodeSet());
                break;
            }
            case 5: {
                Sequence temp = this.getChildren(this.context, contextSequence.toNodeSet());
                break;
            }
            case 0: 
            case 1: {
                Sequence temp = this.getAncestors(this.context, contextSequence.toNodeSet());
                break;
            }
            case 12: {
                Sequence temp = this.getSelf(this.context, contextSequence.toNodeSet());
                break;
            }
            case 2: {
                Sequence temp = this.getParents(this.context, contextSequence.toNodeSet());
                break;
            }
            case 6: 
            case 13: {
                Sequence temp = this.getAttributes(this.context, contextSequence.toNodeSet());
                break;
            }
            case 4: 
            case 10: {
                Sequence temp = this.getSiblings(this.context, contextSequence.toNodeSet());
                break;
            }
            case 9: {
                throw new XPathException("The following axis is not yet supported");
            }
            case 3: {
                throw new XPathException("The preceding axis is not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        if (contextSequence instanceof NodeSet) {
            this.cached = new CachedResult((NodeSet)contextSequence, (Sequence)var3_3);
        }
        var3_3.removeDuplicates();
        return this.predicates.size() == 0 ? var3_3 : this.applyPredicate(contextSequence, (Sequence)var3_3);
    }

    protected Sequence getSelf(XQueryContext context, NodeSet contextSet) {
        if (this.test.isWildcardTest()) {
            if (((TypeTest)this.test).nodeType == -1) {
                if (this.inPredicate) {
                    if (contextSet instanceof VirtualNodeSet) {
                        ((VirtualNodeSet)contextSet).setInPredicate(true);
                        ((VirtualNodeSet)contextSet).setSelfIsContext();
                    } else if (Type.subTypeOf(contextSet.getItemType(), -1)) {
                        Iterator i = contextSet.iterator();
                        while (i.hasNext()) {
                            NodeProxy p = (NodeProxy)i.next();
                            p.addContextNode(p);
                        }
                    }
                }
                return contextSet;
            }
            VirtualNodeSet vset = new VirtualNodeSet(this.axis, this.test, contextSet);
            vset.setInPredicate(this.inPredicate);
            return vset;
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        SelfSelector selector = new SelfSelector(contextSet, this.inPredicate);
        NodeSet result = context.getBroker().getElementIndex().findElementsByTagName((byte)0, docs, this.test.getName(), selector);
        LOG.debug((Object)("Found " + result.getLength() + " for " + this.test.getName() + "; context: " + contextSet.getLength()));
        return result;
    }

    protected NodeSet getAttributes(XQueryContext context, NodeSet contextSet) {
        NodeSet result;
        if (this.test.isWildcardTest()) {
            result = new VirtualNodeSet(this.axis, this.test, contextSet);
            result.setInPredicate(this.inPredicate);
        } else {
            NodeSelector selector = this.axis == 13 ? new DescendantSelector(contextSet, this.inPredicate) : new ChildSelector(contextSet, this.inPredicate);
            DocumentSet docs = this.getDocumentSet(contextSet);
            result = context.getBroker().getElementIndex().getAttributesByName(docs, this.test.getName(), selector);
        }
        return result;
    }

    protected NodeSet getChildren(XQueryContext context, NodeSet contextSet) {
        if (this.test.isWildcardTest()) {
            VirtualNodeSet vset = new VirtualNodeSet(this.axis, this.test, contextSet);
            vset.setInPredicate(this.inPredicate);
            return vset;
        }
        if (this.preloadNodeSets()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            if (this.currentSet == null || this.currentDocs == null || !docs.equals(this.currentDocs)) {
                this.currentDocs = docs;
                this.currentSet = context.getBroker().getElementIndex().findElementsByTagName((byte)0, this.currentDocs, this.test.getName(), null);
            }
            return this.currentSet.selectParentChild(contextSet, 1, this.inPredicate);
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        ChildSelector selector = new ChildSelector(contextSet, this.inPredicate);
        return context.getBroker().getElementIndex().findElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    protected NodeSet getDescendants(XQueryContext context, NodeSet contextSet) {
        if (this.test.isWildcardTest()) {
            VirtualNodeSet vset = new VirtualNodeSet(this.axis, this.test, contextSet);
            vset.setInPredicate(this.inPredicate);
            return vset;
        }
        DocumentSet docs = contextSet.getDocumentSet();
        DescendantSelector selector = this.axis == 8 ? new DescendantOrSelfSelector(contextSet, this.inPredicate) : new DescendantSelector(contextSet, this.inPredicate);
        NodeSet result = context.getBroker().getElementIndex().findElementsByTagName((byte)0, docs, this.test.getName(), selector);
        return result;
    }

    protected NodeSet getSiblings(XQueryContext context, NodeSet contextSet) {
        NodeSet result;
        if (!this.test.isWildcardTest()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            if (this.currentSet == null || this.currentDocs == null || !docs.equals(this.currentDocs)) {
                this.currentDocs = docs;
                this.currentSet = context.getBroker().getElementIndex().findElementsByTagName((byte)0, this.currentDocs, this.test.getName(), null);
            }
            result = this.currentSet.selectSiblings(contextSet, this.axis == 4 ? 2 : 3);
        } else {
            result = new ArraySet(contextSet.getLength());
            Iterator i = contextSet.iterator();
            while (i.hasNext()) {
                NodeProxy p = (NodeProxy)i.next();
                NodeImpl n = (NodeImpl)p.getNode();
                while ((n = this.getNextSibling(n)) != null) {
                    if (!this.test.matches(n)) continue;
                    result.add(new NodeProxy((DocumentImpl)n.getOwnerDocument(), n.getGID(), n.getInternalAddress()));
                }
            }
        }
        return result;
    }

    protected NodeImpl getNextSibling(NodeImpl last) {
        switch (this.axis) {
            case 10: {
                return (NodeImpl)last.getNextSibling();
            }
        }
        return (NodeImpl)last.getPreviousSibling();
    }

    protected NodeSet getFollowing(XQueryContext context, NodeSet contextSet) throws XPathException {
        NodeSet result = NodeSet.EMPTY_SET;
        if (!this.test.isWildcardTest()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            if (this.currentSet == null || this.currentDocs == null || !docs.equals(this.currentDocs)) {
                this.currentDocs = docs;
                this.currentSet = context.getBroker().getElementIndex().findElementsByTagName((byte)0, this.currentDocs, this.test.getName(), null);
            }
            result = contextSet.selectFollowing(this.currentSet);
        }
        return result;
    }

    protected NodeSet getAncestors(XQueryContext context, NodeSet contextSet) {
        NodeSet result;
        if (!this.test.isWildcardTest()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            if (this.currentSet == null || this.currentDocs == null || !docs.equals(this.currentDocs)) {
                this.currentDocs = docs;
                this.currentSet = context.getBroker().getElementIndex().findElementsByTagName((byte)0, this.currentDocs, this.test.getName(), null);
            }
            result = this.currentSet.selectAncestors(contextSet, this.axis == 1, this.inPredicate);
        } else {
            result = new ExtArrayNodeSet();
            Iterator i = contextSet.iterator();
            while (i.hasNext()) {
                NodeProxy p = (NodeProxy)i.next();
                if (this.axis == 1 && this.test.matches(p)) {
                    result.add(new NodeProxy(p.getDocument(), p.gid, p.getInternalAddress()));
                }
                while ((p.gid = XMLUtil.getParentId(p.getDocument(), p.gid)) > 0L) {
                    p.nodeType = 1;
                    if (!this.test.matches(p)) continue;
                    result.add(new NodeProxy(p.getDocument(), p.gid));
                }
            }
        }
        return result;
    }

    protected NodeSet getParents(XQueryContext context, NodeSet contextSet) {
        if (this.test.isWildcardTest()) {
            return contextSet.getParents(this.inPredicate);
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        ParentSelector selector = new ParentSelector(contextSet, this.inPredicate);
        NodeSet result = context.getBroker().getElementIndex().findElementsByTagName((byte)0, docs, this.test.getName(), selector);
        return result;
    }

    protected DocumentSet getDocumentSet(NodeSet contextSet) {
        DocumentSet ds = this.getContextDocSet();
        if (ds == null) {
            ds = contextSet.getDocumentSet();
        }
        return ds;
    }

    public void resetState() {
        super.resetState();
        this.currentSet = null;
        this.currentDocs = null;
        this.cached = null;
    }
}

