/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.OrderedValueSequence;
import org.exist.xquery.value.PreorderedValueSequence;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class LetExpr
extends BindingExpression {
    public LetExpr(XQueryContext context) {
        super(context);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem, Sequence resultSequence) throws XPathException {
        boolean fastOrderBy;
        LocalVariable mark = this.context.markLocalVariables();
        LocalVariable var = new LocalVariable(QName.parse(this.context, this.varName, null));
        this.context.declareVariable(var);
        Sequence in = this.inputSequence.eval(null, null);
        if (this.sequenceType != null) {
            this.sequenceType.checkType(in.getItemType());
            this.sequenceType.checkCardinality(in);
        }
        LetExpr.clearContext(in);
        var.setValue(in);
        Sequence filtered = null;
        if (this.whereExpr != null) {
            filtered = this.applyWhereExpression(null);
            if (this.whereExpr.returnsType() == 23 ? !filtered.effectiveBooleanValue() : filtered.getLength() == 0) {
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        if (fastOrderBy = this.checkOrderSpecs(in)) {
            in = new PreorderedValueSequence(this.orderSpecs, in.toNodeSet());
        }
        if (resultSequence == null) {
            resultSequence = this.orderSpecs != null && !fastOrderBy ? new OrderedValueSequence(this.orderSpecs, in.getLength()) : new ValueSequence();
        }
        if (this.returnExpr instanceof BindingExpression) {
            ((BindingExpression)this.returnExpr).eval(null, null, resultSequence);
        } else {
            in = this.returnExpr.eval(null);
            resultSequence.addAll(in);
        }
        if (this.orderSpecs != null && !fastOrderBy) {
            ((OrderedValueSequence)resultSequence).sort();
        }
        this.context.popLocalVariables(mark);
        return resultSequence;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("(let ");
        buf.append(this.varName);
        if (this.sequenceType != null) {
            buf.append(" as ");
            buf.append(this.sequenceType.toString());
        }
        buf.append(" := ");
        buf.append(this.inputSequence.pprint());
        if (this.whereExpr != null) {
            buf.append(" where ").append(this.whereExpr.pprint());
        }
        if (this.orderSpecs != null) {
            buf.append(" order by ");
            for (int i = 0; i < this.orderSpecs.length; ++i) {
                buf.append(this.orderSpecs[i].toString());
            }
        }
        buf.append(" return ");
        buf.append(this.returnExpr.pprint());
        buf.append(')');
        return buf.toString();
    }
}

