/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.text.Collator;
import java.util.Iterator;
import java.util.Map;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.storage.IndexPaths;
import org.exist.storage.analysis.SimpleTokenizer;
import org.exist.storage.analysis.TextToken;
import org.exist.util.Configuration;
import org.exist.xquery.BinaryOp;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Constants;
import org.exist.xquery.Expression;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtFulltext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class GeneralComparison
extends BinaryOp {
    protected int relation = 4;
    protected int truncation = -1;
    protected CachedResult cached = null;
    protected Expression collationArg = null;

    public GeneralComparison(XQueryContext context, int relation) {
        this(context, relation, -1);
    }

    public GeneralComparison(XQueryContext context, int relation, int truncation) {
        super(context);
        this.relation = relation;
    }

    public GeneralComparison(XQueryContext context, Expression left, Expression right, int relation) {
        this(context, left, right, relation, -1);
    }

    public GeneralComparison(XQueryContext context, Expression left, Expression right, int relation, int truncation) {
        super(context);
        this.relation = relation;
        this.truncation = truncation;
        if (left instanceof PathExpr && ((PathExpr)left).getLength() == 1) {
            left = ((PathExpr)left).getExpression(0);
        }
        this.add(left);
        if (right instanceof PathExpr && ((PathExpr)right).getLength() == 1) {
            right = ((PathExpr)right).getExpression(0);
        }
        this.add(right);
    }

    public int returnsType() {
        if (this.inPredicate && (this.getDependencies() & 2) == 0) {
            return -1;
        }
        return 23;
    }

    public int getDependencies() {
        int leftDeps = this.getLeft().getDependencies();
        int rightDeps = this.getRight().getDependencies();
        if (Type.subTypeOf(this.getLeft().returnsType(), -1) && (leftDeps & 2) == 0 && (rightDeps & 4) == 0) {
            return 1;
        }
        return 3;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence result = null;
        if (this.inPredicate && (this.getDependencies() & 2) == 0) {
            int rtype = this.getRight().returnsType();
            result = (this.getRight().getDependencies() & 2) == 0 && (Type.subTypeOf(rtype, 22) || Type.subTypeOf(rtype, -1) || rtype == 20) && (this.getRight().getCardinality() & 4) == 0 ? this.quickNodeSetCompare(contextSequence) : this.nodeSetCompare(contextSequence);
        }
        if (result == null) {
            result = this.genericCompare(contextSequence, contextItem);
        }
        return result;
    }

    protected Sequence genericCompare(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        Collator collator = this.getCollator(contextSequence);
        if (ls.getLength() == 1 && rs.getLength() == 1) {
            AtomicValue lv = ls.itemAt(0).atomize();
            AtomicValue rv = rs.itemAt(0).atomize();
            return BooleanValue.valueOf(this.compareValues(collator, lv, rv));
        }
        SequenceIterator i1 = ls.iterate();
        while (i1.hasNext()) {
            AtomicValue lv = i1.nextItem().atomize();
            if (rs.getLength() == 1 && this.compareValues(collator, lv, rs.itemAt(0).atomize())) {
                return BooleanValue.TRUE;
            }
            SequenceIterator i2 = rs.iterate();
            while (i2.hasNext()) {
                AtomicValue rv = i2.nextItem().atomize();
                if (!this.compareValues(collator, lv, rv)) continue;
                return BooleanValue.TRUE;
            }
        }
        return BooleanValue.FALSE;
    }

    protected Sequence nodeSetCompare(Sequence contextSequence) throws XPathException {
        NodeSet nodes = (NodeSet)this.getLeft().eval(contextSequence);
        return this.nodeSetCompare(nodes, contextSequence);
    }

    protected Sequence nodeSetCompare(NodeSet nodes, Sequence contextSequence) throws XPathException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Collator collator = this.getCollator(contextSequence);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            NodeProxy current = (NodeProxy)i.next();
            ContextItem c = current.getContext();
            if (c == null) {
                throw new XPathException(this.getASTNode(), "Internal error: context node missing");
            }
            do {
                AtomicValue lv = current.atomize();
                Sequence rs = this.getRight().eval(c.getNode().toSequence());
                SequenceIterator si = rs.iterate();
                while (si.hasNext()) {
                    if (!this.compareValues(collator, lv, si.nextItem().atomize())) continue;
                    result.add(current);
                }
            } while ((c = c.getNextItem()) != null);
        }
        return result;
    }

    protected Sequence quickNodeSetCompare(Sequence contextSequence) throws XPathException {
        if (this.cached != null && this.cached.isValid(contextSequence)) {
            return this.cached.getResult();
        }
        NodeSet nodes = (NodeSet)this.getLeft().eval(contextSequence);
        if (nodes.getLength() < 2) {
            return this.nodeSetCompare(nodes, contextSequence);
        }
        Sequence rightSeq = this.getRight().eval(contextSequence);
        String cmp = rightSeq.getStringValue();
        if (rightSeq.getLength() > 1 || cmp.length() > 2048) {
            return this.nodeSetCompare(nodes, contextSequence);
        }
        DocumentSet docs = nodes.getDocumentSet();
        switch (this.truncation) {
            case 0: {
                cmp = cmp + '%';
                break;
            }
            case 1: {
                cmp = '%' + cmp;
                break;
            }
            case 2: {
                cmp = '%' + cmp + '%';
            }
        }
        if (this.getLeft().returnsType() == -1 && this.relation == 4 && nodes.hasIndex() && cmp.length() > 0) {
            TextToken token;
            int i;
            String cmpCopy = cmp;
            cmp = this.maskWildcards(cmp);
            SimpleTokenizer tokenizer = new SimpleTokenizer();
            tokenizer.setText(cmp);
            boolean foundNumeric = false;
            ExtFulltext containsExpr = new ExtFulltext(this.context, 1);
            containsExpr.setASTNode(this.getASTNode());
            int oldFlags = this.context.getBroker().getTextEngine().getTrackMatches();
            this.context.getBroker().getTextEngine().setTrackMatches(0);
            for (i = 0; i < 5 && (token = tokenizer.nextToken(true)) != null; ++i) {
                if (token.getType() != 2) continue;
                foundNumeric = true;
            }
            if (foundNumeric) {
                foundNumeric = this.checkArgumentTypes(this.context, docs);
            }
            if (!foundNumeric && i > 0) {
                containsExpr.addTerm(new LiteralValue(this.context, new StringValue(cmp)));
                nodes = (NodeSet)containsExpr.eval(nodes, null);
            }
            this.context.getBroker().getTextEngine().setTrackMatches(oldFlags);
            cmp = cmpCopy;
        }
        Collator collator = this.getCollator(contextSequence);
        NodeSet result = this.context.getBroker().getNodesEqualTo(nodes, docs, this.relation, cmp, collator);
        if (contextSequence instanceof NodeSet) {
            this.cached = new CachedResult((NodeSet)contextSequence, result);
        }
        return result;
    }

    protected boolean compareValues(Collator collator, AtomicValue lv, AtomicValue rv) throws XPathException {
        try {
            return GeneralComparison.compareAtomic(collator, lv, rv, this.context.isBackwardsCompatible(), this.truncation, this.relation);
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw e;
        }
    }

    public static boolean compareAtomic(Collator collator, AtomicValue lv, AtomicValue rv, boolean backwardsCompatible, int truncation, int relation) throws XPathException {
        int ltype = lv.getType();
        int rtype = rv.getType();
        if (ltype == 11 || ltype == 20) {
            if (Type.subTypeOf(rtype, 30)) {
                lv = lv.convertTo(34);
            } else if (rtype == 11 || rtype == 20) {
                lv = lv.convertTo(22);
                rv = rv.convertTo(22);
            } else {
                lv = lv.convertTo(rv.getType());
            }
        } else if (rtype == 11 || rtype == 20) {
            if (Type.subTypeOf(ltype, 30)) {
                rv = rv.convertTo(34);
            } else if (rtype == 11 || rtype == 20) {
                lv = lv.convertTo(22);
                rv = rv.convertTo(22);
            } else {
                rv = rv.convertTo(lv.getType());
            }
        }
        if (backwardsCompatible && (Type.subTypeOf(ltype, 30) || Type.subTypeOf(rtype, 30))) {
            lv = lv.convertTo(34);
            rv = rv.convertTo(34);
        }
        switch (truncation) {
            case 0: {
                return lv.startsWith(collator, rv);
            }
            case 1: {
                return lv.endsWith(collator, rv);
            }
            case 2: {
                return lv.contains(collator, rv);
            }
        }
        return lv.compareTo(collator, relation, rv);
    }

    private boolean checkArgumentTypes(XQueryContext context, DocumentSet docs) throws XPathException {
        Configuration config = context.getBroker().getConfiguration();
        Map idxPathMap = (Map)config.getProperty("indexer.map");
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            IndexPaths idx = (IndexPaths)idxPathMap.get(doc.getDoctype().getName());
            if (idx != null && idx.isSelective()) {
                return true;
            }
            if (idx == null || idx.getIncludeAlphaNum()) continue;
            return true;
        }
        return false;
    }

    private String maskWildcards(String expr) {
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < expr.length(); ++i) {
            char ch = expr.charAt(i);
            switch (ch) {
                case '*': {
                    buf.append("\\*");
                    continue block4;
                }
                case '%': {
                    buf.append('*');
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getLeft().pprint());
        buf.append(' ');
        buf.append(Constants.OPS[this.relation]);
        buf.append(' ');
        buf.append(this.getRight().pprint());
        return buf.toString();
    }

    protected void switchOperands() {
        switch (this.relation) {
            case 1: {
                this.relation = 0;
                break;
            }
            case 0: {
                this.relation = 1;
                break;
            }
            case 3: {
                this.relation = 2;
                break;
            }
            case 2: {
                this.relation = 3;
            }
        }
        Expression right = this.getRight();
        this.setRight(this.getLeft());
        this.setLeft(right);
    }

    protected void simplify() {
        if (!Type.subTypeOf(this.getLeft().returnsType(), -1) && Type.subTypeOf(this.getRight().returnsType(), -1)) {
            this.switchOperands();
        } else if ((this.getLeft().getCardinality() & 4) != 0 && (this.getRight().getCardinality() & 4) == 0) {
            this.switchOperands();
        }
    }

    protected Collator getCollator(Sequence contextSequence) throws XPathException {
        if (this.collationArg == null) {
            return this.context.getDefaultCollator();
        }
        String collationURI = this.collationArg.eval(contextSequence).getStringValue();
        return this.context.getCollator(collationURI);
    }

    public void setCollation(Expression collationArg) {
        this.collationArg = collationArg;
    }

    public void resetState() {
        this.getLeft().resetState();
        this.getRight().resetState();
        this.cached = null;
    }
}

