/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.CastExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.InternalModule;
import org.exist.xquery.JavaCall;
import org.exist.xquery.Module;
import org.exist.xquery.PathExpr;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtNear;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Type;

public class FunctionFactory {
    public static Expression createFunction(XQueryContext context, XQueryAST ast, PathExpr parent, List params) throws XPathException {
        QName qname = null;
        try {
            qname = QName.parse(context, ast.getText(), context.getDefaultFunctionNamespace());
        }
        catch (XPathException e) {
            e.setASTNode(ast);
            throw e;
        }
        String local = qname.getLocalName();
        String uri = qname.getNamespaceURI();
        AbstractExpression step = null;
        if (uri.equals("http://www.w3.org/2003/05/xpath-functions")) {
            GeneralComparison op;
            PathExpr p1;
            PathExpr p0;
            if (local.equals("near")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "Function near requires two arguments");
                }
                PathExpr p12 = (PathExpr)params.get(1);
                if (p12.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to near is empty");
                }
                Expression e1 = p12.getExpression(0);
                ExtNear near = new ExtNear(context);
                near.setASTNode(ast);
                near.addTerm(e1);
                near.setPath((PathExpr)params.get(0));
                if (params.size() > 2) {
                    p12 = (PathExpr)params.get(2);
                    if (p12.getLength() == 0) {
                        throw new XPathException(ast, "Distance argument to near is empty");
                    }
                    near.setDistance(p12);
                }
                step = near;
            }
            if (local.equals("starts-with")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "Function starts-with requires two arguments");
                }
                p0 = (PathExpr)params.get(0);
                p1 = (PathExpr)params.get(1);
                if (p1.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to starts-with is empty");
                }
                op = new GeneralComparison(context, p0, p1, 4, 0);
                op.setASTNode(ast);
                if (params.size() == 3) {
                    op.setCollation((Expression)params.get(2));
                }
                step = op;
            }
            if (local.equals("ends-with")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "Function ends-with requires two arguments");
                }
                p0 = (PathExpr)params.get(0);
                p1 = (PathExpr)params.get(1);
                if (p1.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to ends-with is empty");
                }
                op = new GeneralComparison(context, p0, p1, 4, 1);
                op.setASTNode(ast);
                if (params.size() == 3) {
                    op.setCollation((Expression)params.get(2));
                }
                step = op;
            }
            if (local.equals("contains")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "Function contains requires two arguments");
                }
                p0 = (PathExpr)params.get(0);
                p1 = (PathExpr)params.get(1);
                if (p1.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to contains is empty");
                }
                op = new GeneralComparison(context, p0, p1, 4, 2);
                op.setASTNode(ast);
                if (params.size() == 3) {
                    op.setCollation((Expression)params.get(2));
                }
                step = op;
            }
        } else if (uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            if (params.size() != 1) {
                throw new XPathException(ast, "Wrong number of arguments for constructor function");
            }
            PathExpr arg = (PathExpr)params.get(0);
            int code = Type.getType(qname);
            CastExpression castExpr = new CastExpression(context, arg, code, 2);
            castExpr.setASTNode(ast);
            step = castExpr;
        } else if (uri.startsWith("java:")) {
            JavaCall call = new JavaCall(context, qname);
            call.setASTNode(ast);
            call.setArguments(params);
            call.setParent(parent);
            step = call;
        }
        if (step == null) {
            FunctionCall call;
            Module module = context.getModule(uri);
            if (module != null) {
                if (module.isInternalModule()) {
                    FunctionDef def = ((InternalModule)module).getFunctionDef(qname, params.size());
                    if (def == null) {
                        throw new XPathException(ast, "function " + qname.toString() + " ( namespace-uri = " + qname.getNamespaceURI() + ") is not defined");
                    }
                    Function func = Function.createFunction(context, ast, def);
                    func.setArguments(params);
                    func.setParent(parent);
                    step = func;
                } else {
                    UserDefinedFunction func = ((ExternalModule)module).getFunction(qname);
                    if (func == null) {
                        throw new XPathException(ast, "function " + qname.toString() + " ( namespace-uri = " + qname.getNamespaceURI() + ") is not defined");
                    }
                    call = new FunctionCall(context, func);
                    call.setArguments(params);
                    call.setASTNode(ast);
                    step = call;
                }
            } else {
                UserDefinedFunction func = context.resolveFunction(qname);
                if (func != null) {
                    call = new FunctionCall(context, func);
                    call.setASTNode(ast);
                    call.setArguments(params);
                } else {
                    call = new FunctionCall(context, qname, params);
                    call.setASTNode(ast);
                    context.addForwardReference(call);
                }
                step = call;
            }
        }
        return step;
    }
}

