/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.Atomize;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunctionCall
extends Function {
    private UserDefinedFunction functionDef;
    private Expression expression;
    private QName name = null;
    private List arguments = null;

    public FunctionCall(XQueryContext context, QName name, List arguments) {
        super(context);
        this.name = name;
        this.arguments = arguments;
    }

    public FunctionCall(XQueryContext context, UserDefinedFunction functionDef) {
        super(context);
        this.setFunction(functionDef);
    }

    public void setFunction(UserDefinedFunction functionDef) {
        this.functionDef = functionDef;
        this.mySignature = functionDef.getSignature();
        this.expression = functionDef;
        SequenceType returnType = functionDef.getSignature().getReturnType();
        if (returnType.getCardinality() != 7) {
            this.expression = new DynamicCardinalityCheck(this.context, returnType.getCardinality(), this.expression);
        }
        if (Type.subTypeOf(returnType.getPrimaryType(), 20)) {
            this.expression = new Atomize(this.context, this.expression);
        }
        if (Type.subTypeOf(returnType.getPrimaryType(), 30)) {
            this.expression = new UntypedValueCheck(this.context, returnType.getPrimaryType(), this.expression);
        } else if (returnType.getPrimaryType() != 11) {
            this.expression = new DynamicTypeCheck(this.context, returnType.getPrimaryType(), this.expression);
        }
    }

    public void resolveForwardReference(UserDefinedFunction functionDef) throws XPathException {
        this.setFunction(functionDef);
        this.setArguments(this.arguments);
        this.arguments = null;
        this.name = null;
    }

    public QName getQName() {
        return this.name;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence[] seq = new Sequence[this.getArgumentCount()];
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            seq[i] = this.getArgument(i).eval(contextSequence, contextItem);
        }
        this.functionDef.setArguments(seq);
        LocalVariable mark = this.context.markLocalVariables();
        try {
            Sequence returnSeq;
            Sequence sequence = returnSeq = this.expression.eval(contextSequence, contextItem);
            return sequence;
        }
        catch (XPathException e) {
            if (e.getLine() == 0) {
                e.setASTNode(this.getASTNode());
            }
            e.prependMessage("in call to function " + this.functionDef.toString() + " [" + this.getASTNode().getLine() + ", " + this.getASTNode().getColumn() + "]");
            throw e;
        }
        finally {
            this.context.popLocalVariables(mark);
        }
    }

    public void resetState() {
        this.functionDef.resetState();
    }
}

