/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AtomicToString;
import org.exist.xquery.Atomize;
import org.exist.xquery.Cardinality;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public abstract class Function
extends PathExpr {
    public static final String BUILTIN_FUNCTION_NS = "http://www.w3.org/2003/05/xpath-functions";
    protected FunctionSignature mySignature;
    private Expression parent;
    private XQueryAST astNode = null;

    protected Function(XQueryContext context, FunctionSignature signature) {
        super(context);
        this.mySignature = signature;
    }

    protected Function(XQueryContext context) {
        super(context);
    }

    public int returnsType() {
        if (this.mySignature == null) {
            return 11;
        }
        if (this.mySignature.getReturnType() == null) {
            throw new IllegalArgumentException("Return type for function " + this.mySignature.getName() + " is not defined");
        }
        return this.mySignature.getReturnType().getPrimaryType();
    }

    public int getCardinality() {
        if (this.mySignature.getReturnType() == null) {
            throw new IllegalArgumentException("Return type for function " + this.mySignature.getName() + " is not defined");
        }
        return this.mySignature.getReturnType().getCardinality();
    }

    public static Function createFunction(XQueryContext context, XQueryAST ast, FunctionDef def) throws XPathException {
        Class fclass = def.getImplementingClass();
        if (def == null || fclass == null) {
            throw new XPathException(ast, "Class for function is null");
        }
        try {
            Object obj;
            Object[] initArgs = new Object[]{context};
            Class[] constructorArgs = new Class[]{XQueryContext.class};
            Constructor construct = null;
            try {
                construct = fclass.getConstructor(constructorArgs);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (construct == null) {
                constructorArgs = new Class[]{XQueryContext.class, FunctionSignature.class};
                construct = fclass.getConstructor(constructorArgs);
                if (construct == null) {
                    throw new XPathException(ast, "Constructor not found");
                }
                initArgs = new Object[]{context, def.getSignature()};
            }
            if ((obj = construct.newInstance(initArgs)) instanceof Function) {
                ((Function)obj).setASTNode(ast);
                return (Function)obj;
            }
            throw new XPathException(ast, "Function object does not implement interface function");
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new XPathException(ast, "Function implementation class " + fclass.getName() + " not found");
        }
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    public Expression getParent() {
        return this.parent;
    }

    public void setArguments(List arguments) throws XPathException {
        SequenceType[] argumentTypes = this.mySignature.getArgumentTypes();
        if (!this.mySignature.isOverloaded() && arguments.size() != this.mySignature.getArgumentCount()) {
            throw new XPathException(this.getASTNode(), "number of arguments to function " + this.getName() + " doesn't match function signature (expected " + this.mySignature.getArgumentCount() + ", got " + arguments.size() + ')');
        }
        SequenceType argType = null;
        for (int i = 0; i < arguments.size(); ++i) {
            if (argumentTypes != null && i < argumentTypes.length) {
                argType = argumentTypes[i];
            }
            Expression next = this.checkArgument((Expression)arguments.get(i), argType);
            this.steps.add(next);
        }
    }

    protected Expression checkArgument(Expression expr, SequenceType type) throws XPathException {
        boolean cardinalityMatches;
        if (type == null) {
            return expr;
        }
        boolean bl = cardinalityMatches = type.getCardinality() == 7;
        if (!cardinalityMatches) {
            boolean bl2 = cardinalityMatches = (expr.getCardinality() | type.getCardinality()) == type.getCardinality();
            if (!cardinalityMatches && expr.getCardinality() == 1 && (type.getCardinality() & 1) == 0) {
                throw new XPathException(this.astNode, "Argument " + expr.pprint() + " is empty. An " + "empty argument is not allowed here.");
            }
        }
        int returnType = expr.returnsType();
        boolean typeMatches = type.getPrimaryType() == 11;
        typeMatches = Type.subTypeOf(returnType, type.getPrimaryType());
        if (typeMatches && cardinalityMatches) {
            return expr;
        }
        if (this.context.isBackwardsCompatible()) {
            if (Type.subTypeOf(type.getPrimaryType(), 22)) {
                if (!Type.subTypeOf(returnType, 20)) {
                    expr = new Atomize(this.context, expr);
                    returnType = 20;
                }
                expr = new AtomicToString(this.context, expr);
                returnType = 22;
            } else if (type.getPrimaryType() == 30 || Type.subTypeOf(type.getPrimaryType(), 34)) {
                if (!Type.subTypeOf(returnType, 20)) {
                    expr = new Atomize(this.context, expr);
                    returnType = 20;
                }
                expr = new UntypedValueCheck(this.context, type.getPrimaryType(), expr);
                returnType = type.getPrimaryType();
            }
        }
        if (Type.subTypeOf(type.getPrimaryType(), 20)) {
            if (!Type.subTypeOf(returnType, 20)) {
                expr = new Atomize(this.context, expr);
            }
            if (type.getPrimaryType() != 20) {
                expr = new UntypedValueCheck(this.context, type.getPrimaryType(), expr);
            }
            returnType = expr.returnsType();
        }
        if (!Type.subTypeOf(returnType, type.getPrimaryType()) && !Type.subTypeOf(type.getPrimaryType(), returnType) && returnType != 11) {
            throw new XPathException(this.astNode, "Supplied argument " + expr.pprint() + " doesn't match required type: required: " + type.toString() + "; got: " + Type.getTypeName(returnType) + Cardinality.display(expr.getCardinality()));
        }
        if (!typeMatches) {
            expr = new DynamicTypeCheck(this.context, type.getPrimaryType(), expr);
        }
        if (!cardinalityMatches) {
            expr = new DynamicCardinalityCheck(this.context, type.getCardinality(), expr);
        }
        return expr;
    }

    public abstract Sequence eval(Sequence var1, Item var2) throws XPathException;

    public Sequence[] getArguments(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        int argCount = this.getArgumentCount();
        Sequence[] args = new Sequence[argCount];
        for (int i = 0; i < argCount; ++i) {
            args[i] = this.getArgument(i).eval(contextSequence, contextItem);
        }
        return args;
    }

    public Expression getArgument(int pos) {
        return this.getExpression(pos);
    }

    public int getArgumentCount() {
        return this.steps.size();
    }

    public QName getName() {
        return this.mySignature.getName();
    }

    public FunctionSignature getSignature() {
        return this.mySignature;
    }

    public boolean isCalledAs(String localName) {
        return localName.equals(this.mySignature.getName().getLocalName());
    }

    public int getDependencies() {
        return 3;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append('(');
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            Expression e = (Expression)i.next();
            buf.append(e.pprint());
            buf.append(',');
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append(')');
        return buf.toString();
    }

    public void setASTNode(XQueryAST ast) {
        this.astNode = ast;
    }

    public XQueryAST getASTNode() {
        return this.astNode;
    }
}

