/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.NodeSet;
import org.exist.xquery.CombiningExpression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class Except
extends CombiningExpression {
    public Except(XQueryContext context, PathExpr left, PathExpr right) {
        super(context, left, right);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence lval = this.left.eval(contextSequence, contextItem);
        Sequence rval = this.right.eval(contextSequence, contextItem);
        if (rval.getLength() == 0 || lval.getLength() == 0) {
            return lval;
        }
        if (lval.getItemType() != -1 || rval.getItemType() != -1) {
            throw new XPathException("except operand is not a node sequence");
        }
        NodeSet result = lval.toNodeSet().except(rval.toNodeSet());
        return result;
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.left.pprint());
        buf.append(" union ");
        buf.append(this.right.pprint());
        return buf.toString();
    }
}

