/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.Atomize;
import org.exist.xquery.AttributeConstructor;
import org.exist.xquery.Expression;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.xml.sax.helpers.AttributesImpl;

public class ElementConstructor
extends NodeConstructor {
    private Expression qnameExpr;
    private PathExpr content = null;
    private AttributeConstructor[] attributes = null;
    private QName[] namespaceDecls = null;
    private boolean isDynamic = true;

    public ElementConstructor(XQueryContext context) {
        super(context);
    }

    public ElementConstructor(XQueryContext context, String qname) {
        super(context);
        this.qnameExpr = new LiteralValue(context, new StringValue(qname));
        this.isDynamic = false;
    }

    public void setContent(PathExpr path) {
        this.content = path;
    }

    public void setNameExpr(Expression expr) {
        this.qnameExpr = new Atomize(this.context, expr);
    }

    public void addAttribute(AttributeConstructor attr) {
        if (attr.isNamespaceDeclaration()) {
            if (attr.getQName().equals("xmlns")) {
                this.addNamespaceDecl("", attr.getLiteralValue());
            } else {
                this.addNamespaceDecl(QName.extractLocalName(attr.getQName()), attr.getLiteralValue());
            }
        } else if (this.attributes == null) {
            this.attributes = new AttributeConstructor[1];
            this.attributes[0] = attr;
        } else {
            AttributeConstructor[] natts = new AttributeConstructor[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, natts, 0, this.attributes.length);
            natts[this.attributes.length] = attr;
            this.attributes = natts;
        }
    }

    public void addNamespaceDecl(String prefix, String uri) {
        if (this.namespaceDecls == null) {
            this.namespaceDecls = new QName[1];
            this.namespaceDecls[0] = new QName(prefix, uri, "xmlns");
        } else {
            QName[] decls = new QName[this.namespaceDecls.length + 1];
            System.arraycopy(this.namespaceDecls, 0, decls, 0, this.namespaceDecls.length);
            decls[this.namespaceDecls.length] = new QName(prefix, uri, "xmlns");
            this.namespaceDecls = decls;
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        int i;
        this.context.pushInScopeNamespaces();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        if (this.namespaceDecls != null) {
            for (int i2 = 0; i2 < this.namespaceDecls.length; ++i2) {
                this.context.declareInScopeNamespace(this.namespaceDecls[i2].getLocalName(), this.namespaceDecls[i2].getNamespaceURI());
            }
        }
        AttributesImpl attrs = new AttributesImpl();
        if (this.attributes != null) {
            AttributeConstructor constructor;
            for (i = 0; i < this.attributes.length; ++i) {
                constructor = this.attributes[i];
                if (!constructor.isNamespaceDeclaration()) continue;
                int p = constructor.getQName().indexOf(58);
                if (p < 0) {
                    this.context.declareInScopeNamespace("", constructor.getLiteralValue());
                    continue;
                }
                String prefix = constructor.getQName().substring(p + 1);
                this.context.declareInScopeNamespace(prefix, constructor.getLiteralValue());
            }
            for (i = 0; i < this.attributes.length; ++i) {
                this.context.proceed(this, builder);
                constructor = this.attributes[i];
                Sequence attrValues = constructor.eval(contextSequence, contextItem);
                QName attrQName = QName.parse(this.context, constructor.getQName(), "");
                attrs.addAttribute(attrQName.getNamespaceURI(), attrQName.getLocalName(), attrQName.toString(), "CDATA", attrValues.getStringValue());
            }
        }
        this.context.proceed(this, builder);
        Sequence qnameSeq = this.qnameExpr.eval(contextSequence, contextItem);
        if (qnameSeq.getLength() != 1) {
            throw new XPathException("Type error: the node name should evaluate to a single string");
        }
        QName qn = QName.parse(this.context, qnameSeq.getStringValue());
        int nodeNr = builder.startElement(qn, attrs);
        if (this.namespaceDecls != null) {
            for (i = 0; i < this.namespaceDecls.length; ++i) {
                builder.namespaceNode(this.namespaceDecls[i]);
            }
        }
        if (this.content != null) {
            this.content.eval(contextSequence, contextItem);
        }
        builder.endElement();
        NodeImpl node = builder.getDocument().getNode(nodeNr);
        this.context.popInScopeNamespaces();
        return node;
    }

    public String pprint() {
        if (this.isDynamic) {
            return this.pprintDynamic();
        }
        StringBuffer buf = new StringBuffer();
        buf.append('<').append(this.qnameExpr.pprint());
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                AttributeConstructor attr = this.attributes[i];
                buf.append(' ').append(attr.pprint());
            }
        }
        if (this.content == null) {
            buf.append("/>");
        } else {
            buf.append('>');
            buf.append(this.content.pprint());
            buf.append("</").append(this.qnameExpr.pprint()).append('>');
        }
        return buf.toString();
    }

    public String pprintDynamic() {
        StringBuffer buf = new StringBuffer();
        buf.append("element { ");
        buf.append(this.qnameExpr.pprint());
        buf.append(" } { ");
        if (this.content != null) {
            buf.append(this.content.pprint());
        }
        buf.append(" }");
        return buf.toString();
    }

    public void setPrimaryAxis(int axis) {
        if (this.content != null) {
            this.content.setPrimaryAxis(axis);
        }
    }

    public void resetState() {
        if (this.content != null) {
            this.content.resetState();
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                AttributeConstructor next = this.attributes[i];
                next.resetState();
            }
        }
    }
}

