/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class DynamicTypeCheck
extends AbstractExpression {
    private Expression expression;
    private int requiredType;

    public DynamicTypeCheck(XQueryContext context, int requiredType, Expression expr) {
        super(context);
        this.requiredType = requiredType;
        this.expression = expr;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (Type.subTypeOf(item.getType(), this.requiredType)) continue;
            throw new XPathException(this.expression.getASTNode(), "Type error in expression: required type is " + Type.getTypeName(this.requiredType) + "; got: " + Type.getTypeName(item.getType()) + ": " + item.getStringValue());
        }
        return seq;
    }

    public String pprint() {
        return this.expression.pprint();
    }

    public int returnsType() {
        return this.requiredType;
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void resetState() {
        this.expression.resetState();
    }

    public XQueryAST getASTNode() {
        return this.expression.getASTNode();
    }
}

