/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.Atomize;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DynamicCommentConstructor
extends NodeConstructor {
    private Expression content;

    public DynamicCommentConstructor(XQueryContext context, Expression contentExpr) {
        super(context);
        this.content = new Atomize(context, contentExpr);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence contentSeq = this.content.eval(contextSequence, contextItem);
        if (contentSeq.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        StringBuffer buf = new StringBuffer();
        SequenceIterator i = contentSeq.iterate();
        while (i.hasNext()) {
            this.context.proceed(this, builder);
            Item next = i.nextItem();
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(next.toString());
        }
        int nodeNr = builder.comment(buf.toString());
        return builder.getDocument().getNode(nodeNr);
    }

    public String pprint() {
        StringBuffer buf = new StringBuffer();
        buf.append("comment { ").append(this.content.pprint()).append(" }");
        return buf.toString();
    }
}

