/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class AtomicToString
extends AbstractExpression {
    Expression expression;

    public AtomicToString(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        if (seq.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ValueSequence result = new ValueSequence();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            result.add(new StringValue(next.getStringValue()));
        }
        return result;
    }

    public String pprint() {
        return this.expression.pprint() + " cast as xs:string";
    }

    public int returnsType() {
        return 22;
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public void resetState() {
        this.expression.resetState();
    }
}

