/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InternalModule;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.value.Sequence;

public abstract class AbstractInternalModule
implements InternalModule {
    private static final Logger LOG = Logger.getLogger((Class)AbstractInternalModule.class);
    protected TreeMap mFunctionMap = new TreeMap();
    protected FunctionDef[] mFunctions;
    protected TreeMap mGlobalVariables = new TreeMap();

    public AbstractInternalModule(FunctionDef[] functions) {
        this.mFunctions = functions;
        for (int i = 0; i < functions.length; ++i) {
            FunctionSignature signature = functions[i].getSignature();
            this.mFunctionMap.put(signature.getFunctionId(), functions[i]);
        }
    }

    private AbstractInternalModule() {
    }

    public boolean isInternalModule() {
        return true;
    }

    public abstract String getNamespaceURI();

    public abstract String getDefaultPrefix();

    public FunctionSignature[] listFunctions() {
        FunctionSignature[] signatures = new FunctionSignature[this.mFunctions.length];
        for (int i = 0; i < signatures.length; ++i) {
            signatures[i] = this.mFunctions[i].getSignature();
        }
        return signatures;
    }

    public Iterator getSignaturesForFunction(QName qname) {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(2);
        for (int i = 0; i < this.mFunctions.length; ++i) {
            FunctionSignature signature = this.mFunctions[i].getSignature();
            if (signature.getName().compareTo(qname) != 0) continue;
            signatures.add(signature);
        }
        return signatures.iterator();
    }

    public FunctionDef getFunctionDef(QName qname, int argCount) {
        FunctionId id = new FunctionId(qname, argCount);
        return (FunctionDef)this.mFunctionMap.get(id);
    }

    public Variable declareVariable(QName qname, Object value) throws XPathException {
        Sequence val = XPathUtil.javaObjectToXPath(value);
        Variable var = (Variable)this.mGlobalVariables.get(qname);
        if (var == null) {
            var = new Variable(qname);
            this.mGlobalVariables.put(qname, var);
        }
        var.setValue(val);
        return var;
    }

    public Variable resolveVariable(QName qname) throws XPathException {
        return (Variable)this.mGlobalVariables.get(qname);
    }
}

