/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc.test;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;

public class XmlRpcTest
extends TestCase {
    private static final String URI = "http://localhost:8081";
    private static final String XML_DATA = "<test><para>\u00e4\u00e4\u00f6\u00f6\u00fc\u00fc\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc\u00df\u00df</para><para>\uc5f4\ub2e8\uacc4</para></test>";
    private static final String XSL_DATA = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"><xsl:param name=\"testparam\"/><xsl:template match=\"test\"><test><xsl:apply-templates/></test></xsl:template><xsl:template match=\"para\"><p><xsl:value-of select=\"$testparam\"/>: <xsl:apply-templates/></p></xsl:template></xsl:stylesheet>";
    private static final String TARGET_COLLECTION = "/db/xmlrpc/";
    private WebServer webServer = null;

    public static void main(String[] args) {
        TestRunner.run((Test)new XmlRpcTest("XmlRpcTest"));
    }

    public XmlRpcTest(String name) {
        super(name);
    }

    public void testStore() throws Exception {
        System.out.println("Creating collection /db/xmlrpc/");
        XmlRpcClient xmlrpc = this.getClient();
        Vector<Object> params = new Vector<Object>();
        params.addElement(TARGET_COLLECTION);
        Boolean result = (Boolean)xmlrpc.execute("createCollection", params);
        XmlRpcTest.assertTrue((boolean)result);
        System.out.println("Storing document <test><para>\u00e4\u00e4\u00f6\u00f6\u00fc\u00fc\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc\u00df\u00df</para><para>\uc5f4\ub2e8\uacc4</para></test>");
        params.clear();
        params.addElement(XML_DATA);
        params.addElement("/db/xmlrpc/test.xml");
        params.addElement(new Integer(1));
        result = (Boolean)xmlrpc.execute("parse", params);
        XmlRpcTest.assertTrue((boolean)result);
        params.setElementAt(XSL_DATA, 0);
        params.setElementAt("/db/xmlrpc/test.xsl", 1);
        result = (Boolean)xmlrpc.execute("parse", params);
        XmlRpcTest.assertTrue((boolean)result);
        System.out.println("Documents stored.");
    }

    public void testRetrieveDoc() throws Exception {
        System.out.println("Retrieving document /db/xmlrpc/test.xml");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("indent", "yes");
        options.put("encoding", "UTF-8");
        options.put("expand-xincludes", "yes");
        options.put("process-xsl-pi", "no");
        Vector<Object> params = new Vector<Object>();
        params.addElement("/db/xmlrpc/test.xml");
        params.addElement(options);
        XmlRpcClient xmlrpc = this.getClient();
        byte[] data = (byte[])xmlrpc.execute("getDocument", params);
        System.out.println(new String(data, "UTF-8"));
        System.out.println("Retrieving document with stylesheet applied");
        options.put("stylesheet", "test.xsl");
        data = (byte[])xmlrpc.execute("getDocument", params);
        System.out.println(new String(data, "UTF-8"));
    }

    public void testCharEncoding() throws Exception {
        System.out.println("Testing charsets returned by query");
        Vector<Object> params = new Vector<Object>();
        String query = "distinct-values(//para)";
        params.addElement(query.getBytes("UTF-8"));
        params.addElement(new Hashtable());
        XmlRpcClient xmlrpc = this.getClient();
        Hashtable result = (Hashtable)xmlrpc.execute("queryP", params);
        Vector resources = (Vector)result.get("results");
        XmlRpcTest.assertEquals((int)resources.size(), (int)2);
        String value = (String)resources.elementAt(0);
        XmlRpcTest.assertEquals((String)value, (String)"\u00e4\u00e4\u00f6\u00f6\u00fc\u00fc\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc\u00df\u00df");
        System.out.println("Result1: " + value);
        value = (String)resources.elementAt(1);
        XmlRpcTest.assertEquals((String)value, (String)"\uc5f4\ub2e8\uacc4");
        System.out.println("Result2: " + value);
    }

    public void testQuery() throws Exception {
        Vector<Object> params = new Vector<Object>();
        String query = "(::pragma exist:serialize indent=no::) //para";
        params.addElement(query.getBytes("UTF-8"));
        params.addElement(new Integer(10));
        params.addElement(new Integer(1));
        params.addElement(new Hashtable());
        XmlRpcClient xmlrpc = this.getClient();
        byte[] result = (byte[])xmlrpc.execute("query", params);
        XmlRpcTest.assertNotNull((Object)result);
        XmlRpcTest.assertTrue((result.length > 0 ? 1 : 0) != 0);
        System.out.println(new String(result, "UTF-8"));
    }

    public void testQueryWithStylesheet() throws Exception {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("stylesheet", "test.xsl");
        options.put("stylesheet-param.testparam", "Test");
        options.put("omit-xml-declaration", "yes");
        Vector<Object> params = new Vector<Object>();
        String query = "//para[1]";
        params.addElement(query.getBytes("UTF-8"));
        params.addElement(options);
        XmlRpcClient xmlrpc = this.getClient();
        Integer handle = (Integer)xmlrpc.execute("executeQuery", params);
        XmlRpcTest.assertNotNull((Object)handle);
        params.clear();
        params.addElement(handle);
        params.addElement(new Integer(0));
        params.addElement(options);
        byte[] item = (byte[])xmlrpc.execute("retrieve", params);
        XmlRpcTest.assertNotNull((Object)item);
        XmlRpcTest.assertTrue((item.length > 0 ? 1 : 0) != 0);
        String out = new String(item, "UTF-8");
        System.out.println("Received: " + out);
        XmlRpcTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><p>Test: \u00e4\u00e4\u00f6\u00f6\u00fc\u00fc\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc\u00df\u00df</p>", (String)out);
    }

    public void testExecuteQuery() throws Exception {
        Vector<Object> params = new Vector<Object>();
        String query = "distinct-values(//para)";
        params.addElement(query.getBytes("UTF-8"));
        params.addElement(new Hashtable());
        XmlRpcClient xmlrpc = this.getClient();
        System.out.println("Executing query: " + query);
        Integer handle = (Integer)xmlrpc.execute("executeQuery", params);
        XmlRpcTest.assertNotNull((Object)handle);
        params.clear();
        params.addElement(handle);
        Integer hits = (Integer)xmlrpc.execute("getHits", params);
        XmlRpcTest.assertNotNull((Object)hits);
        System.out.println("Found: " + hits);
        XmlRpcTest.assertEquals((int)hits, (int)2);
        params.addElement(new Integer(1));
        params.addElement(new Hashtable());
        byte[] item = (byte[])xmlrpc.execute("retrieve", params);
        System.out.println(new String(item, "UTF-8"));
    }

    public void testCollectionWithAccents() throws Exception {
        System.out.println("Creating collection with accents in name ...");
        Vector<Object> params = new Vector<Object>();
        params.addElement("/db/Citt\u00e0");
        XmlRpcClient xmlrpc = this.getClient();
        xmlrpc.execute("createCollection", params);
        System.out.println("Storing document <test><para>\u00e4\u00e4\u00f6\u00f6\u00fc\u00fc\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc\u00df\u00df</para><para>\uc5f4\ub2e8\uacc4</para></test>");
        params.clear();
        params.addElement(XML_DATA);
        params.addElement("/db/Citt\u00e0/test.xml");
        params.addElement(new Integer(1));
        Boolean result = (Boolean)xmlrpc.execute("parse", params);
        XmlRpcTest.assertTrue((boolean)result);
        params.clear();
        params.addElement("/db");
        Hashtable collection = (Hashtable)xmlrpc.execute("describeCollection", params);
        Vector collections = (Vector)collection.get("collections");
        String colWithAccent = null;
        for (int i = 0; i < collections.size(); ++i) {
            String childName = (String)collections.elementAt(i);
            if (childName.equals("Citt\u00e0")) {
                colWithAccent = childName;
            }
            System.out.println("Child collection: " + childName);
        }
        XmlRpcTest.assertNotNull((String)"added collection not found", colWithAccent);
        System.out.println("Retrieving document /db/Citt\u00e0/test.xml");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("indent", "yes");
        options.put("encoding", "UTF-8");
        options.put("expand-xincludes", "yes");
        options.put("process-xsl-pi", "no");
        params.clear();
        params.addElement("/db/" + colWithAccent + "/test.xml");
        params.addElement(options);
        byte[] data = (byte[])xmlrpc.execute("getDocument", params);
        System.out.println(new String(data, "UTF-8"));
    }

    protected XmlRpcClient getClient() throws MalformedURLException {
        XmlRpc.setEncoding((String)"UTF-8");
        XmlRpcClient xmlrpc = new XmlRpcClient(URI);
        xmlrpc.setBasicAuthentication("admin", "");
        return xmlrpc;
    }
}

