/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcServer;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.xmlrpc.AuthenticatedHandler;

public class RpcServlet
extends HttpServlet {
    protected XmlRpcServer xmlrpc;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = "admin";
        String password = null;
        String auth = request.getHeader("Authorization");
        if (auth != null) {
            byte[] c = Base64.decode((byte[])auth.substring(6).getBytes());
            String s = new String(c);
            int p = s.indexOf(58);
            user = s.substring(0, p);
            password = s.substring(p + 1);
        }
        byte[] result = this.xmlrpc.execute((InputStream)request.getInputStream(), user, password);
        response.setContentType("text/xml");
        response.setContentLength(result.length);
        ServletOutputStream output = response.getOutputStream();
        output.write(result);
        output.flush();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!BrokerPool.isConfigured()) {
            throw new ServletException("database is not running");
        }
        boolean enableDebug = false;
        String param = config.getInitParameter("debug");
        if (param != null) {
            enableDebug = param.equalsIgnoreCase("true");
        }
        try {
            BrokerPool pool = BrokerPool.getInstance();
            Configuration conf = pool.getConfiguration();
            this.xmlrpc = new XmlRpcServer();
            AuthenticatedHandler rpcserv = new AuthenticatedHandler(conf);
            this.xmlrpc.addHandler("$default", (Object)rpcserv);
            XmlRpc.setDebug((boolean)enableDebug);
            XmlRpc.setEncoding((String)"UTF-8");
        }
        catch (EXistException e) {
            throw new ServletException((Throwable)e);
        }
        catch (XmlRpcException e) {
            throw new ServletException(e.getMessage());
        }
    }
}

