/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xmlrpc.QueryResult;
import org.exist.xmlrpc.RpcAPI;
import org.exist.xmlrpc.RpcConnection;
import org.xml.sax.SAXException;

public class RpcServer
implements RpcAPI {
    private static Logger LOG = Logger.getLogger((Class)RpcServer.class);
    protected static final int MIN_CONNECT = 1;
    protected static final int MAX_CONNECT = 10;
    protected ConnectionPool pool;

    public RpcServer(Configuration conf) throws EXistException {
        this.pool = new ConnectionPool(1, 10, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createCollection(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            con.createCollection(user, name);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createId(User user, String collection) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String string = con.createId(user, collection);
            return string;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQuery(User user, String xpath, Hashtable parameters) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            int n = con.executeQuery(user, xpath, parameters);
            return n;
        }
        catch (Exception e) {
            this.handleException(e);
            int n = -1;
            return n;
        }
        finally {
            this.pool.release(con);
        }
    }

    public int executeQuery(User user, byte[] xpath, String encoding, Hashtable parameters) throws EXistException, PermissionDeniedException {
        String xpathString = null;
        if (encoding != null) {
            try {
                xpathString = new String(xpath, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (xpathString == null) {
            xpathString = new String(xpath);
        }
        LOG.debug((Object)("query: " + xpathString));
        return this.executeQuery(user, xpathString, parameters);
    }

    public int executeQuery(User user, byte[] xpath, Hashtable parameters) throws EXistException, PermissionDeniedException {
        return this.executeQuery(user, xpath, null, parameters);
    }

    public Hashtable getCollectionDesc(User user, String rootCollection) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.getCollectionDesc(user, rootCollection);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new EXistException("collection " + rootCollection + " not found!");
        }
        finally {
            this.pool.release(con);
        }
    }

    public Hashtable describeResource(User user, String resourceName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.describeResource(user, resourceName);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new EXistException("resource " + resourceName + " not found!");
        }
        finally {
            this.pool.release(con);
        }
    }

    public Hashtable describeCollection(User user, String rootCollection) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.describeCollection(user, rootCollection);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new EXistException("collection " + rootCollection + " not found!");
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDocument(User user, String name, String encoding, int prettyPrint) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable<String, String> parametri = new Hashtable<String, String>();
            if (prettyPrint > 0) {
                parametri.put("indent", "yes");
            } else {
                parametri.put("indent", "no");
            }
            parametri.put("encoding", encoding);
            String xml = con.getDocument(user, name, parametri);
            if (xml == null) {
                throw new EXistException("document " + name + " not found!");
            }
            try {
                byte[] byArray = xml.getBytes(encoding);
                return byArray;
            }
            catch (UnsupportedEncodingException uee) {
                try {
                    byte[] byArray = xml.getBytes();
                    this.pool.release(con);
                    return byArray;
                }
                catch (Exception e) {
                    this.handleException(e);
                    byte[] byArray = null;
                    return byArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDocument(User user, String name, String encoding, int prettyPrint, String stylesheet) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable<String, String> parametri = new Hashtable<String, String>();
            if (prettyPrint > 0) {
                parametri.put("indent", "yes");
            } else {
                parametri.put("indent", "no");
            }
            if (stylesheet != null) {
                parametri.put("stylesheet", stylesheet);
            }
            parametri.put("encoding", encoding);
            String xml = con.getDocument(user, name, parametri);
            if (xml == null) {
                throw new EXistException("document " + name + " not found!");
            }
            try {
                byte[] byArray = xml.getBytes(encoding);
                return byArray;
            }
            catch (UnsupportedEncodingException uee) {
                try {
                    byte[] byArray = xml.getBytes();
                    this.pool.release(con);
                    return byArray;
                }
                catch (Exception e) {
                    this.handleException(e);
                    byte[] byArray = null;
                    return byArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.release(con);
        }
    }

    public String getDocumentAsString(User user, String name, int prettyPrint) throws EXistException, PermissionDeniedException {
        return this.getDocumentAsString(user, name, prettyPrint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentAsString(User user, String name, int prettyPrint, String stylesheet) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String xml;
            Hashtable<String, String> parametri = new Hashtable<String, String>();
            if (prettyPrint > 0) {
                parametri.put("indent", "yes");
            } else {
                parametri.put("indent", "no");
            }
            if (stylesheet != null) {
                parametri.put("stylesheet", stylesheet);
            }
            if ((xml = con.getDocument(user, name, parametri)) == null) {
                throw new EXistException("document " + name + " not found!");
            }
            String string = xml;
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryResource(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            byte[] byArray = con.getBinaryResource(user, name);
            return byArray;
        }
        catch (Exception e) {
            this.handleException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentAsString(User user, String name, Hashtable parameters) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String string = con.getDocument(user, name, parameters);
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDocument(User user, String name, Hashtable parametri) throws EXistException, PermissionDeniedException {
        String encoding = "UTF-8";
        String compression = "no";
        encoding = (String)parametri.get("encoding") == null ? "UTF-8" : (String)parametri.get("encoding");
        if ((String)parametri.get("compress-output") != null) {
            compression = (String)parametri.get("compress-output");
        }
        RpcConnection con = this.pool.get();
        try {
            String xml;
            block13: {
                xml = con.getDocument(user, name, parametri);
                if (xml == null) {
                    throw new EXistException("document " + name + " not found!");
                }
                try {
                    if (!compression.equals("no")) break block13;
                    byte[] byArray = xml.getBytes(encoding);
                    return byArray;
                }
                catch (UnsupportedEncodingException uee) {
                    if (compression.equals("no")) {
                        byte[] byArray = xml.getBytes();
                        return byArray;
                    }
                    LOG.debug((Object)"getdocument with compression");
                    byte[] byArray = RpcServer.compress(xml.getBytes());
                    return byArray;
                }
            }
            LOG.debug((Object)"getdocument with compression");
            byte[] byArray = RpcServer.compress(xml.getBytes(encoding));
            return byArray;
        }
        catch (Exception e) {
            this.handleException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDocumentData(User user, String name, Hashtable parameters) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.getDocumentData(user, name, parameters);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getNextChunk(User user, String handle, int offset) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.getNextChunk(user, handle, offset);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumentListing(User user) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Vector result;
            Vector vector = result = con.getDocumentListing(user);
            return vector;
        }
        catch (Exception e) {
            this.handleException(e);
            Vector vector = null;
            return vector;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumentListing(User user, String collection) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Vector result;
            Vector vector = result = con.getDocumentListing(user, collection);
            return vector;
        }
        catch (Exception e) {
            this.handleException(e);
            Vector vector = null;
            return vector;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable listDocumentPermissions(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.listDocumentPermissions(user, name);
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable listCollectionPermissions(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.listCollectionPermissions(user, name);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHits(User user, int resultId) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            int n = con.getHits(user, resultId);
            return n;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getPermissions(User user, String docName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.getPermissions(user, docName);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getCreationDate(User user, String collectionName) throws PermissionDeniedException, EXistException {
        RpcConnection con = this.pool.get();
        try {
            Date date = con.getCreationDate(user, collectionName);
            return date;
        }
        catch (Exception e) {
            this.handleException(e);
            Date date = null;
            return date;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTimestamps(User user, String documentName) throws PermissionDeniedException, EXistException {
        RpcConnection con = this.pool.get();
        try {
            Vector vector = con.getTimestamps(user, documentName);
            return vector;
        }
        catch (Exception e) {
            this.handleException(e);
            Vector vector = null;
            return vector;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getUser(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            Hashtable hashtable = con.getUser(user, name);
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUsers(User user) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            Vector vector = con.getUsers(user);
            return vector;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getGroups(User user) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            Vector vector = con.getGroups(user);
            return vector;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIndexedElements(User user, String collectionName, boolean inclusive) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            Vector vector = con.getIndexedElements(user, collectionName, inclusive);
            return vector;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector scanIndexTerms(User user, String collectionName, String start, String end, boolean inclusive) throws PermissionDeniedException, EXistException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            Vector vector = con.scanIndexTerms(user, collectionName, start, end, inclusive);
            return vector;
        }
        finally {
            this.pool.release(con);
        }
    }

    private void handleException(Exception e) throws EXistException, PermissionDeniedException {
        LOG.debug((Object)e.getMessage(), (Throwable)e);
        if (e instanceof EXistException) {
            throw (EXistException)e;
        }
        if (e instanceof PermissionDeniedException) {
            throw (PermissionDeniedException)e;
        }
        System.out.println(e.getClass().getName());
        throw new EXistException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDocument(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.hasDocument(user, name);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceCount(User user, String collectionName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            int n = con.getResourceCount(user, collectionName);
            return n;
        }
        catch (Exception e) {
            this.handleException(e);
            int n = 0;
            return n;
        }
        finally {
            this.pool.release(con);
        }
    }

    public boolean parse(User user, byte[] xmlData, String docName) throws EXistException, PermissionDeniedException {
        return this.parse(user, xmlData, docName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(User user, byte[] xmlData, String docName, int overwrite) throws EXistException, PermissionDeniedException {
        if (xmlData[xmlData.length - 1] == 0) {
            byte[] temp = new byte[xmlData.length - 1];
            System.arraycopy(xmlData, 0, temp, 0, xmlData.length - 1);
            xmlData = temp;
        }
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.parse(user, xmlData, docName, overwrite != 0);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(User user, String xml, String docName, int overwrite) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.parse(user, xml.getBytes("UTF-8"), docName, overwrite != 0);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseLocal(User user, String localFile, String docName, boolean replace) throws EXistException, PermissionDeniedException, SAXException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.parseLocal(user, localFile, docName, replace);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    public String uploadCompressed(User user, byte[] data, int length) throws EXistException, PermissionDeniedException {
        return this.uploadCompressed(user, null, data, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadCompressed(User user, String file, byte[] data, int length) throws EXistException, PermissionDeniedException {
        LOG.debug((Object)("Compressed upload: " + data.length));
        RpcConnection con = this.pool.get();
        try {
            data = RpcServer.uncompress(data);
            String string = con.upload(user, data, data.length, file);
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    public String upload(User user, byte[] data, int length) throws EXistException, PermissionDeniedException {
        return this.upload(user, null, data, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(User user, String file, byte[] data, int length) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String string = con.upload(user, data, length, file);
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    public boolean parse(User user, String xml, String docName) throws EXistException, PermissionDeniedException {
        return this.parse(user, xml, docName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeBinary(User user, byte[] data, String docName, boolean replace) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.storeBinary(user, data, docName, replace);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createResourceId(User user, String collection) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String string = con.createResourceId(user, collection);
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    public Hashtable queryP(User user, byte[] xpath, Hashtable parameters) throws EXistException, PermissionDeniedException {
        return this.queryP(user, xpath, null, null, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable queryP(User user, byte[] xpath, String docName, String s_id, Hashtable parameters) throws EXistException, PermissionDeniedException {
        String xpathString = null;
        try {
            xpathString = new String(xpath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EXistException("failed to decode xpath expression");
        }
        if (xpathString.charAt(xpathString.length() - 1) == '\u0000') {
            xpathString = xpathString.substring(0, xpathString.length() - 1);
        }
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.queryP(user, xpathString, docName, s_id, parameters);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseQueryResult(User user, int handle) {
        RpcConnection con = this.pool.get();
        try {
            con.releaseQueryResult(handle);
        }
        finally {
            this.pool.release(con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] query(User user, byte[] xquery, int howmany, int start, Hashtable parameters) throws EXistException, PermissionDeniedException {
        String xqueryStr;
        RpcConnection con = this.pool.get();
        try {
            xqueryStr = new String(xquery, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            xqueryStr = new String(xquery);
        }
        String result = null;
        try {
            result = con.query(user, xqueryStr, howmany, start, parameters);
            byte[] byArray = result.getBytes("UTF-8");
            return byArray;
        }
        catch (Exception e) {
            this.handleException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable querySummary(User user, int resultId) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.summary(user, resultId);
            return hashtable;
        }
        finally {
            this.pool.release(con);
        }
    }

    public Hashtable querySummary(User user, String xpath) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            Hashtable hashtable = con.summary(user, xpath);
            return hashtable;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new EXistException(e);
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(User user, String docName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            con.remove(user, docName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyCollection(User user, String collectionPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.moveOrCopyCollection(user, collectionPath, destinationPath, newName, false);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveCollection(User user, String collectionPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.moveOrCopyCollection(user, collectionPath, destinationPath, newName, true);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveResource(User user, String docPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.moveOrCopyResource(user, docPath, destinationPath, newName, true);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyResource(User user, String docPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.moveOrCopyResource(user, docPath, destinationPath, newName, false);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCollection(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.removeCollection(user, name);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            con.synchronize();
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            boolean bl = con.removeUser(user, name);
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    public byte[] retrieve(User user, String doc, String id) throws EXistException, PermissionDeniedException {
        return this.retrieve(user, doc, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieve(User user, String doc, String id, Hashtable parameters) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        String xml = null;
        try {
            xml = con.retrieve(user, doc, id, parameters);
            try {
                String encoding = (String)parameters.get("encoding");
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                byte[] byArray = xml.getBytes(encoding);
                return byArray;
            }
            catch (UnsupportedEncodingException uee) {
                try {
                    byte[] byArray = xml.getBytes();
                    this.pool.release(con);
                    return byArray;
                }
                catch (Exception e) {
                    this.handleException(e);
                    byte[] byArray = null;
                    return byArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveAsString(User user, String doc, String id, Hashtable parameters) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String string = con.retrieve(user, doc, id, parameters);
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = null;
            return string;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieve(User user, int resultId, int num, Hashtable parameters) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String xml = con.retrieve(user, resultId, num, parameters);
            String encoding = (String)parameters.get("encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                byte[] byArray = xml.getBytes(encoding);
                return byArray;
            }
            catch (UnsupportedEncodingException uee) {
                try {
                    byte[] byArray = xml.getBytes();
                    this.pool.release(con);
                    return byArray;
                }
                catch (Exception e) {
                    this.handleException(e);
                    byte[] byArray = null;
                    return byArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieveAll(User user, int resultId, Hashtable parameters) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            String xml = con.retrieveAll(user, resultId, parameters);
            String encoding = (String)parameters.get("encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                byte[] byArray = xml.getBytes(encoding);
                return byArray;
            }
            catch (UnsupportedEncodingException uee) {
                try {
                    byte[] byArray = xml.getBytes();
                    this.pool.release(con);
                    return byArray;
                }
                catch (Exception e) {
                    this.handleException(e);
                    byte[] byArray = null;
                    return byArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.release(con);
        }
    }

    public boolean setPermissions(User user, String resource, String permissions) throws EXistException, PermissionDeniedException {
        return this.setPermissions(user, resource, null, null, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPermissions(User user, String resource, String owner, String ownerGroup, String permissions) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            boolean bl = con.setPermissions(user, resource, owner, ownerGroup, permissions);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPermissions(User user, String resource, int permissions) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            boolean bl = con.setPermissions(user, resource, null, null, permissions);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPermissions(User user, String resource, String owner, String ownerGroup, int permissions) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            boolean bl = con.setPermissions(user, resource, owner, ownerGroup, permissions);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUser(User user, String name, String password, Vector groups, String home) throws EXistException, PermissionDeniedException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            boolean bl = con.setUser(user, name, password, groups, home);
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    public boolean setUser(User user, String name, String password, Vector groups) throws EXistException, PermissionDeniedException {
        return this.setUser(user, name, password, groups, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int xupdate(User user, String collectionName, byte[] xupdate) throws PermissionDeniedException, EXistException, SAXException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            String xupdateStr = new String(xupdate, "UTF-8");
            int n = con.xupdate(user, collectionName, xupdateStr);
            return n;
        }
        catch (Exception e) {
            this.handleException(e);
            int n = 0;
            return n;
        }
        finally {
            this.pool.release(con);
        }
    }

    public int xupdateResource(User user, String resource, byte[] xupdate) throws PermissionDeniedException, EXistException, SAXException {
        return this.xupdateResource(user, resource, xupdate, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int xupdateResource(User user, String resource, byte[] xupdate, String encoding) throws PermissionDeniedException, EXistException, SAXException {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            String xupdateStr = new String(xupdate, encoding);
            int n = con.xupdateResource(user, resource, xupdateStr);
            return n;
        }
        catch (Exception e) {
            this.handleException(e);
            int n = 0;
            return n;
        }
        finally {
            this.pool.release(con);
        }
    }

    public boolean shutdown(User user) throws PermissionDeniedException {
        return this.shutdown(user, 0L);
    }

    public boolean shutdown(User user, long delay) throws PermissionDeniedException {
        if (!user.hasGroup("dba")) {
            throw new PermissionDeniedException("not allowed to shut downthe database");
        }
        if (delay > 0L) {
            TimerTask task = new TimerTask(){

                public void run() {
                    try {
                        BrokerPool.stop();
                    }
                    catch (EXistException e) {
                        LOG.warn((Object)"shutdown failed", (Throwable)e);
                    }
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, delay);
        } else {
            try {
                BrokerPool.stop();
            }
            catch (EXistException e) {
                LOG.warn((Object)"shutdown failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(User user) {
        RpcConnection con = null;
        try {
            con = this.pool.get();
            con.sync();
        }
        finally {
            this.pool.release(con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyCollection(User user, String name, String namedest) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String nome;
            this.createCollection(user, namedest);
            Hashtable<String, String> parametri = new Hashtable<String, String>();
            parametri.put("indent", "no");
            parametri.put("expand-xincludes", "no");
            parametri.put("encoding", "UTF-8");
            Hashtable lista = this.getCollectionDesc(user, name);
            Vector collezioni = (Vector)lista.get("collections");
            Vector documents = (Vector)lista.get("documents");
            Iterator collezioniItr = collezioni.iterator();
            while (collezioniItr.hasNext()) {
                nome = collezioniItr.next().toString();
                this.createCollection(user, namedest + "/" + nome);
                this.copyCollection(user, name + "/" + nome, namedest + "/" + nome);
            }
            int dsize = documents.size();
            for (int i = 0; i < dsize; ++i) {
                Hashtable hash = (Hashtable)documents.elementAt(i);
                nome = (String)hash.get("name");
                int p = nome.lastIndexOf(47);
                if (p > -1) {
                    nome = nome.substring(p + 1);
                }
                byte[] xml = this.getDocument(user, name + "/" + nome, parametri);
                this.parse(user, xml, namedest + "/" + nome);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockResource(User user, String path, String userName) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            con.lockResource(user, path, userName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hasUserLock(User user, String path) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            String string = con.hasUserLock(user, path);
            return string;
        }
        catch (Exception e) {
            this.handleException(e);
            String string = "";
            return string;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockResource(User user, String path) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            con.unlockResource(user, path);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    public static byte[] compress(byte[] whatToCompress) throws IOException {
        return RpcServer.compress(whatToCompress, whatToCompress.length);
    }

    public static byte[] compress(byte[] whatToCompress, int length) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream gzos = new ZipOutputStream(baos);
        gzos.setMethod(8);
        gzos.putNextEntry(new ZipEntry(length + ""));
        gzos.write(whatToCompress, 0, length);
        gzos.closeEntry();
        gzos.finish();
        gzos.close();
        return baos.toByteArray();
    }

    public static byte[] uncompress(byte[] whatToUncompress) throws IOException {
        int bread;
        ByteArrayInputStream bais = new ByteArrayInputStream(whatToUncompress);
        ZipInputStream gzis = new ZipInputStream(bais);
        ZipEntry zipentry = gzis.getNextEntry();
        int len = Integer.parseInt(zipentry.getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((bread = gzis.read(buf)) != -1) {
            baos.write(buf, 0, bread);
        }
        gzis.closeEntry();
        gzis.close();
        return baos.toByteArray();
    }

    public Vector getDocumentChunk(User user, String name, Hashtable parameters) throws EXistException, PermissionDeniedException, IOException {
        Vector<String> result = new Vector<String>();
        File file = File.createTempFile("rpc", ".xml");
        FileOutputStream os = new FileOutputStream(file.getAbsolutePath(), true);
        os.write(this.getDocument(user, name, parameters));
        os.close();
        result.addElement(file.getName());
        result.addElement(Long.toString(file.length()));
        file.deleteOnExit();
        LOG.debug((Object)("The file is created with name: " + file.getName()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDocumentChunk(User user, String name, int start, int len) throws EXistException, PermissionDeniedException, IOException {
        RpcConnection con = this.pool.get();
        try {
            byte[] byArray = con.getDocumentChunk(user, name, start, len);
            return byArray;
        }
        finally {
            this.pool.release(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reindexCollection(User user, String name) throws EXistException, PermissionDeniedException {
        RpcConnection con = this.pool.get();
        try {
            con.reindexCollection(user, name);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.handleException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(con);
        }
    }

    class ConnectionPool {
        public static final int CHECK_INTERVAL = 5000;
        public static final int TIMEOUT = 180000;
        protected Configuration conf;
        protected int connections = 0;
        protected long lastCheck = System.currentTimeMillis();
        protected int max = 1;
        protected int min = 0;
        protected Int2ObjectHashMap resultSets = new Int2ObjectHashMap(128);
        protected Stack pool = new Stack();
        protected ArrayList threads = new ArrayList();

        public ConnectionPool(int min, int max, Configuration conf) {
            this.min = min;
            this.max = max;
            this.conf = conf;
            this.initialize();
        }

        private void checkResultSets() {
            Iterator i = this.resultSets.valueIterator();
            while (i.hasNext()) {
                QueryResult qr = (QueryResult)i.next();
                long ts = qr.timestamp;
                if (System.currentTimeMillis() - ts <= 180000L) continue;
                LOG.debug((Object)("releasing result set " + qr.hashCode()));
                i.remove();
            }
        }

        protected RpcConnection createConnection() {
            try {
                RpcConnection con = new RpcConnection(this.conf, this);
                this.threads.add(con);
                con.start();
                ++this.connections;
                return con;
            }
            catch (EXistException ee) {
                LOG.warn((Object)ee);
                return null;
            }
        }

        public synchronized RpcConnection get() {
            if (this.pool.isEmpty()) {
                if (this.connections < this.max) {
                    return this.createConnection();
                }
                while (this.pool.isEmpty()) {
                    LOG.debug((Object)"waiting for connection to become available");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            RpcConnection con = (RpcConnection)this.pool.pop();
            this.notifyAll();
            if (System.currentTimeMillis() - this.lastCheck > 5000L) {
                this.checkResultSets();
            }
            return con;
        }

        protected void initialize() {
            for (int i = 0; i < this.min; ++i) {
                RpcConnection con = this.createConnection();
                this.pool.push(con);
            }
        }

        public synchronized void release(RpcConnection con) {
            this.pool.push(con);
            this.notifyAll();
        }

        public synchronized void shutdown() {
            Iterator i = this.threads.iterator();
            while (i.hasNext()) {
                ((RpcConnection)i.next()).terminate();
            }
            while (this.pool.size() < this.connections) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            try {
                BrokerPool.stop();
            }
            catch (EXistException e) {
                LOG.warn((Object)"shutdown failed", (Throwable)e);
            }
        }

        public synchronized void synchronize() {
            Iterator i = this.threads.iterator();
            while (i.hasNext()) {
                ((RpcConnection)i.next()).synchronize();
            }
        }
    }
}

