/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test.concurrent;

import java.io.File;
import junit.framework.Assert;
import org.exist.xmldb.test.concurrent.Action;
import org.exist.xmldb.test.concurrent.DBUtils;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;

public class ReplaceResourceAction
extends Action {
    protected static final String XML = "<config><user id=\"george\"><phone>+49 69 888478</phone><email>george@email.com</email><customer-id>64534233</customer-id><bank-account>7466356</bank-account></user><user id=\"sam\"><phone>+49 69 774345</phone><email>sam@email.com</email><customer-id>993834</customer-id><bank-account>364553</bank-account></user></config>";
    private static final String TEST_QUERY1 = "//user[@id = 'george']/phone[contains(., '69')]/text()";
    private static final String TEST_QUERY2 = "//user[@id = 'sam']/customer-id[. = '993834']";
    private static final String TEST_QUERY3 = "//user[email = 'sam@email.com']";
    private File tempFile;
    private int count = 0;

    public ReplaceResourceAction(String collectionPath, String resourceName) {
        super(collectionPath, resourceName);
    }

    public boolean execute() throws Exception {
        Collection col = DatabaseManager.getCollection((String)this.collectionPath, (String)"admin", null);
        String xml = "<data now=\"" + System.currentTimeMillis() + "\" count=\"" + ++this.count + "\">" + XML + "</data>";
        DBUtils.addXMLResource(col, "R1.xml", xml);
        ResourceSet result = DBUtils.query(col, TEST_QUERY1);
        Assert.assertEquals((long)1L, (long)result.getSize());
        Assert.assertEquals((Object)"+49 69 888478", (Object)result.getResource(0L).getContent());
        result = DBUtils.query(col, TEST_QUERY2);
        Assert.assertEquals((long)1L, (long)result.getSize());
        result = DBUtils.query(col, TEST_QUERY3);
        Assert.assertEquals((long)1L, (long)result.getSize());
        return false;
    }
}

