/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test.concurrent;

import org.exist.xmldb.test.concurrent.Action;
import org.exist.xmldb.test.concurrent.XMLGenerator;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

class RemoveAppendAction
extends Action {
    private static final String REMOVE = "<xu:modifications xmlns:xu=\"http://www.xmldb.org/xupdate\" version=\"1.0\"><xu:remove select=\"//ELEMENT[last()]\"></xu:remove></xu:modifications>";
    protected XMLGenerator xmlGenerator;

    public RemoveAppendAction(String collectionPath, String resourceName, String[] wordList) {
        super(collectionPath, resourceName);
        this.xmlGenerator = new XMLGenerator(1, 5, 1, wordList);
    }

    public boolean execute() throws Exception {
        Collection col = DatabaseManager.getCollection((String)this.collectionPath, (String)"admin", null);
        XUpdateQueryService service = (XUpdateQueryService)col.getService("XUpdateQueryService", "1.0");
        this.append(service);
        this.remove(service);
        return false;
    }

    private void remove(XUpdateQueryService service) throws XMLDBException {
        System.out.println(Thread.currentThread().getName() + ": removing elements ...");
        for (int i = 0; i < 10; ++i) {
            service.update(REMOVE);
        }
    }

    private void append(XUpdateQueryService service) throws Exception {
        String updateOpen = "<xu:modifications xmlns:xu=\"http://www.xmldb.org/xupdate\" version=\"1.0\"><xu:append select=\"/ROOT-ELEMENT\" child=\"1\">";
        String updateClose = "</xu:append></xu:modifications>";
        System.out.println(Thread.currentThread().getName() + ": inserting elements ...");
        for (int i = 0; i < 10; ++i) {
            String update = "<xu:modifications xmlns:xu=\"http://www.xmldb.org/xupdate\" version=\"1.0\"><xu:append select=\"/ROOT-ELEMENT\" child=\"1\">" + this.xmlGenerator.generateElement() + "</xu:append></xu:modifications>";
            service.update(update);
        }
    }
}

