/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test.concurrent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.exist.source.StringSource;
import org.exist.util.Occurrences;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.XQueryService;
import org.exist.xmldb.test.concurrent.XMLGenerator;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class DBUtils {
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";

    public static Collection setupDB(String uri) throws Exception {
        Class<?> cl = Class.forName(DRIVER);
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
        return DatabaseManager.getCollection((String)uri, (String)"admin", null);
    }

    public static void shutdownDB(String uri) throws XMLDBException {
        Collection collection = DatabaseManager.getCollection((String)uri, (String)"admin", null);
        if (collection != null) {
            DatabaseInstanceManager manager = (DatabaseInstanceManager)collection.getService("DatabaseInstanceManager", "1.0");
            manager.shutdown();
            collection.close();
        }
    }

    public static File generateXMLFile(int elementCnt, int attrCnt, String[] wordList) throws Exception {
        File file = File.createTempFile(Thread.currentThread().getName(), ".xml");
        if (file.exists() && !file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to output file " + file.getAbsolutePath());
        }
        System.out.println("Generating XML file " + file.getAbsolutePath());
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        XMLGenerator gen = new XMLGenerator(elementCnt, attrCnt, 2, wordList);
        gen.generateXML(writer);
        ((Writer)writer).close();
        return file;
    }

    public static Collection addCollection(Collection parent, String name) throws XMLDBException {
        CollectionManagementService service = DBUtils.getCollectionManagementService(parent);
        return service.createCollection(name);
    }

    public static void removeCollection(Collection parent, String name) throws XMLDBException {
        CollectionManagementService service = DBUtils.getCollectionManagementService(parent);
        service.removeCollection(name);
    }

    public static CollectionManagementService getCollectionManagementService(Collection col) throws XMLDBException {
        return (CollectionManagementService)col.getService("CollectionManagementService", "1.0");
    }

    public static void addXMLResource(Collection col, String resourceId, File file) throws XMLDBException {
        XMLResource res = (XMLResource)col.createResource(resourceId, "XMLResource");
        res.setContent((Object)file);
        col.storeResource((Resource)res);
    }

    public static void addXMLResource(Collection col, String resourceId, String contents) throws XMLDBException {
        XMLResource res = (XMLResource)col.createResource(resourceId, "XMLResource");
        res.setContent((Object)contents);
        col.storeResource((Resource)res);
    }

    public static ResourceSet query(Collection collection, String xpath) throws XMLDBException {
        XPathQueryService service = DBUtils.getQueryService(collection);
        return service.query(xpath);
    }

    public static ResourceSet xquery(Collection collection, String xquery) throws XMLDBException {
        XQueryService service = DBUtils.getXQueryService(collection);
        StringSource source = new StringSource(xquery);
        return service.execute(source);
    }

    public static XPathQueryService getQueryService(Collection collection) throws XMLDBException {
        return (XPathQueryService)collection.getService("XPathQueryService", "1.0");
    }

    public static XQueryService getXQueryService(Collection collection) throws XMLDBException {
        return (XQueryService)collection.getService("XQueryService", "1.0");
    }

    public static String[] wordList(Collection root) throws XMLDBException {
        IndexQueryService service = (IndexQueryService)root.getService("IndexQueryService", "1.0");
        Occurrences[] terms = service.scanIndexTerms("a", "z", true);
        String[] words = new String[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            words[i] = terms[i].getTerm().toString();
        }
        System.out.println("Size of the word list: " + words.length);
        return words;
    }
}

