/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test.concurrent;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.exist.xmldb.test.concurrent.Action;
import org.exist.xmldb.test.concurrent.DBUtils;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.CollectionManagementService;

public abstract class ConcurrentTestBase
extends TestCase {
    protected String rootColURI;
    protected Collection rootCol;
    protected String testColName;
    protected Collection testCol;
    protected List actions = new ArrayList(5);
    protected volatile boolean failed = false;

    public ConcurrentTestBase(String name, String uri, String testCollection) {
        super(name);
        this.rootColURI = uri;
        this.testColName = testCollection;
    }

    public void addAction(Action action, int repeat, long delayBeforeStart, long delay) {
        this.actions.add(new Runner(action, repeat, delayBeforeStart, delay));
    }

    public Collection getTestCollection() {
        return this.testCol;
    }

    public void testConcurrent() throws Exception {
        Thread t;
        int i;
        for (i = 0; i < this.actions.size(); ++i) {
            t = (Thread)this.actions.get(i);
            t.start();
        }
        try {
            for (i = 0; i < this.actions.size(); ++i) {
                t = (Thread)this.actions.get(i);
                t.join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConcurrentTestBase.assertFalse((boolean)this.failed);
    }

    protected void setUp() throws Exception {
        this.rootCol = DBUtils.setupDB(this.rootColURI);
        this.testCol = this.rootCol.getChildCollection(this.testColName);
        if (this.testCol != null) {
            CollectionManagementService mgr = DBUtils.getCollectionManagementService(this.rootCol);
            mgr.removeCollection(this.testColName);
        }
        this.testCol = DBUtils.addCollection(this.rootCol, this.testColName);
        ConcurrentTestBase.assertNotNull((Object)this.testCol);
        DBUtils.addXMLResource(this.rootCol, "biblio.rdf", new File("samples/biblio.rdf"));
    }

    protected void tearDown() throws Exception {
        Resource res = this.rootCol.getResource("biblio.rdf");
        this.rootCol.removeResource(res);
        DBUtils.removeCollection(this.rootCol, this.testColName);
        DBUtils.shutdownDB(this.rootColURI);
    }

    class Runner
    extends Thread {
        private Action action;
        private int repeat;
        private long delay = 0L;
        private long delayBeforeStart = 0L;

        public Runner(Action action, int repeat, long delayBeforeStart, long delay) {
            this.action = action;
            this.repeat = repeat;
            this.delay = delay;
            this.delayBeforeStart = delayBeforeStart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.delayBeforeStart > 0L) {
                Runner runner = this;
                synchronized (runner) {
                    try {
                        this.wait(this.delayBeforeStart);
                    }
                    catch (InterruptedException e) {
                        System.err.println("Action failed in Thread " + this.getName() + ": " + e.getMessage());
                        e.printStackTrace();
                        ConcurrentTestBase.this.failed = true;
                    }
                }
            }
            try {
                for (int i = 0; i < this.repeat && !ConcurrentTestBase.this.failed; ++i) {
                    ConcurrentTestBase.this.failed = this.action.execute();
                    if (this.delay <= 0L) continue;
                    Runner runner = this;
                    synchronized (runner) {
                        this.wait(this.delay);
                        continue;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Action failed in Thread " + this.getName() + ": " + e.getMessage());
                e.printStackTrace();
                ConcurrentTestBase.this.failed = true;
            }
        }
    }
}

