/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.xerces.impl.Version;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.SAXSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.XMLResource;

public class TestEXistXMLSerialize
extends TestCase {
    private static final String XML_DATA = "<test><para>\u00e4\u00e4\u00f6\u00f6\u00fc\u00fc\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc\u00df\u00df</para><para>\uc5f4\ub2e8\uacc4</para></test>";
    private static final String XSL_DATA = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"><xsl:param name=\"testparam\"/><xsl:template match=\"test\"><test><xsl:apply-templates/></test></xsl:template><xsl:template match=\"para\"><p><xsl:value-of select=\"$testparam\"/>: <xsl:apply-templates/></p></xsl:template></xsl:stylesheet>";
    Collection c = null;
    Database database = null;
    File testFile = new File("src/org/exist/xmldb/test/PerformanceTest.xml");

    public TestEXistXMLSerialize(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
        this.database = (Database)cl.newInstance();
        this.database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)this.database);
        this.c = DatabaseManager.getCollection((String)"xmldb:exist:///db");
    }

    public void tearDown() throws Exception {
        DatabaseManager.deregisterDatabase((Database)this.database);
    }

    public void testSerialize1() throws Exception {
        System.out.println("Xerces version: " + Version.getVersion());
        XMLResource resource = (XMLResource)this.c.createResource(null, "XMLResource");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.testFile);
        resource.setContentAsDOM((Node)doc);
        System.out.println("Storing resource: " + resource.getId());
        this.c.storeResource((Resource)resource);
        resource = (XMLResource)this.c.getResource(resource.getId());
        Node node = resource.getContentAsDOM();
        node = node.getOwnerDocument();
        System.out.println("Attempting serialization 1");
        DOMSource source = new DOMSource(node);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        System.out.println("Using javax.xml.transform.Transformer");
        System.out.println("---------------------");
        System.out.println(new String(out.toByteArray()));
        System.out.println("--------------------- ");
    }

    public void testSerialize2() throws Exception {
        System.out.println("Xerces version: " + Version.getVersion());
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.testFile);
        XMLResource resource = (XMLResource)this.c.createResource(null, "XMLResource");
        resource.setContentAsDOM((Node)doc);
        System.out.println("Storing resource: " + resource.getId());
        this.c.storeResource((Resource)resource);
        resource = (XMLResource)this.c.getResource(resource.getId());
        Node node = resource.getContentAsDOM();
        System.out.println("Attempting serialization using XMLSerializer");
        OutputFormat format = new OutputFormat();
        format.setLineWidth(0);
        format.setIndent(5);
        format.setPreserveSpace(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)out, format);
        if (node instanceof Document) {
            serializer.serialize((Document)node);
        } else if (node instanceof Element) {
            serializer.serialize((Element)node);
        } else {
            throw new Exception("Can't serialize node type: " + node);
        }
        System.out.println("Using org.apache.xml.serialize.XMLSerializer");
        System.out.println("---------------------");
        System.out.println(new String(out.toByteArray()));
        System.out.println("--------------------- ");
    }

    public void testSerialize3() throws Exception {
        System.out.println("Xerces version: " + Version.getVersion());
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.testFile);
        XMLResource resource = (XMLResource)this.c.createResource(null, "XMLResource");
        resource.setContentAsDOM((Node)doc);
        System.out.println("Storing resource: " + resource.getId());
        this.c.storeResource((Resource)resource);
        resource = (XMLResource)this.c.getResource(resource.getId());
        Node node = resource.getContentAsDOM();
        System.out.println("Attempting serialization using eXist's serializer");
        StringWriter writer = new StringWriter();
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", "yes");
        DOMSerializer serializer = new DOMSerializer(writer, outputProperties);
        serializer.serialize(node);
        System.out.println("Using org.exist.util.serializer.DOMSerializer");
        System.out.println("---------------------");
        System.out.println(writer.toString());
        System.out.println("---------------------");
    }

    public void testSerialize4() throws Exception {
        System.out.println("Xerces version: " + Version.getVersion());
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.testFile);
        XMLResource resource = (XMLResource)this.c.createResource(null, "XMLResource");
        resource.setContentAsDOM((Node)doc);
        System.out.println("Storing resource: " + resource.getId());
        this.c.storeResource((Resource)resource);
        resource = (XMLResource)this.c.getResource(resource.getId());
        Node node = resource.getContentAsDOM();
        System.out.println("Attempting serialization using eXist's SAX serializer");
        StringWriter writer = new StringWriter();
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", "yes");
        SAXSerializer serializer = new SAXSerializer(writer, outputProperties);
        resource.getContentAsSAX((ContentHandler)serializer);
        System.out.println("Using org.exist.util.serializer.SAXSerializer");
        System.out.println("---------------------");
        System.out.println(writer.toString());
        System.out.println("---------------------");
    }

    public void testSerialize5() throws Exception {
        XMLResource resource = (XMLResource)this.c.createResource("test.xml", "XMLResource");
        resource.setContent((Object)XML_DATA);
        System.out.println("Storing resource: " + resource.getId());
        this.c.storeResource((Resource)resource);
        XMLResource style = (XMLResource)this.c.createResource("test.xsl", "XMLResource");
        style.setContent((Object)XSL_DATA);
        System.out.println("Storing resource: " + style.getId());
        this.c.storeResource((Resource)style);
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", "yes");
        this.c.setProperty("stylesheet", "test.xsl");
        this.c.setProperty("stylesheet-param.testparam", "TEST");
        StringWriter writer = new StringWriter();
        SAXSerializer serializer = new SAXSerializer(writer, outputProperties);
        resource.getContentAsSAX((ContentHandler)serializer);
        System.out.println("Using org.exist.util.serializer.SAXSerializer");
        System.out.println("---------------------");
        System.out.println(writer.toString());
        System.out.println("---------------------");
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Class)TestEXistXMLSerialize.class);
    }
}

