/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class ResourceTest
extends TestCase {
    private static final String URI = "xmldb:exist:///db";
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";

    public ResourceTest(String arg0) {
        super(arg0);
    }

    public void testReadNonExistingResource() {
        try {
            Collection testCollection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            ResourceTest.assertNotNull((Object)testCollection);
            Resource nonExistent = testCollection.getResource("12345.xml");
            ResourceTest.assertNull((Object)nonExistent);
        }
        catch (Exception e) {
            System.out.println("testReadNonExistingResource(): Exception: " + e);
            ResourceTest.fail((String)e.getMessage());
        }
    }

    public void testReadResource() {
        try {
            Collection testCollection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            ResourceTest.assertNotNull((Object)testCollection);
            String[] resources = testCollection.listResources();
            ResourceTest.assertEquals((int)resources.length, (int)testCollection.getResourceCount());
            System.out.println("reading " + resources[0]);
            XMLResource doc = (XMLResource)testCollection.getResource(resources[0]);
            ResourceTest.assertNotNull((Object)doc);
            System.out.println("testing XMLResource.getContentAsSAX()");
            StringWriter sout = new StringWriter();
            OutputFormat format = new OutputFormat("xml", "ISO-8859-1", true);
            format.setLineWidth(60);
            XMLSerializer xmlout = new XMLSerializer((Writer)sout, format);
            doc.getContentAsSAX((ContentHandler)xmlout);
            System.out.println("----------------------------------------");
            System.out.println(sout.toString());
            System.out.println("----------------------------------------");
        }
        catch (Exception e) {
            System.out.println("testReadResource(): Exception: " + e);
            ResourceTest.fail((String)e.getMessage());
        }
    }

    public void testReadDOM() {
        try {
            Collection testCollection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            ResourceTest.assertNotNull((Object)testCollection);
            XMLResource doc = (XMLResource)testCollection.getResource("r_and_j.xml");
            ResourceTest.assertNotNull((Object)doc);
            Element elem = (Element)doc.getContentAsDOM();
            ResourceTest.assertNotNull((Object)elem);
            ResourceTest.assertEquals((String)elem.getNodeName(), (String)"PLAY");
            System.out.println("Root element: " + elem.getNodeName());
            NodeList children = elem.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                System.out.println("Child: " + node.getNodeName());
                ResourceTest.assertNotNull((Object)node);
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    System.out.println("child: " + node.getNodeName());
                }
            }
        }
        catch (XMLDBException e) {
            ResourceTest.fail((String)e.getMessage());
        }
    }

    public void testSetContentAsSAX() {
        try {
            Collection testCollection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            ResourceTest.assertNotNull((Object)testCollection);
            XMLResource doc = (XMLResource)testCollection.createResource("test.xml", "XMLResource");
            String xml = "<test><title>Title</title><para>Paragraph1</para><para>Paragraph2</para></test>";
            ContentHandler handler = doc.setContentAsSAX();
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(false);
            SAXParser sax = saxFactory.newSAXParser();
            XMLReader reader = sax.getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
            testCollection.storeResource((Resource)doc);
        }
        catch (Exception e) {
            ResourceTest.fail((String)e.getMessage());
        }
    }

    public void testSetContentAsDOM() {
        try {
            Collection testCollection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            ResourceTest.assertNotNull((Object)testCollection);
            XMLResource doc = (XMLResource)testCollection.createResource("dom.xml", "XMLResource");
            String xml = "<test><title>Title</title><para>Paragraph1</para><para>Paragraph2</para></test>";
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            Document dom = builder.parse(new InputSource(new StringReader(xml)));
            doc.setContentAsDOM((Node)dom.getDocumentElement());
            testCollection.storeResource((Resource)doc);
        }
        catch (Exception e) {
            ResourceTest.fail((String)e.getMessage());
        }
    }

    public void testAddRemove() {
        try {
            String resourceID = "addremove.xml";
            XMLResource created = this.addResource("addremove.xml", this.xmlForTest());
            ResourceTest.assertNotNull((Object)created);
            XMLResource located = this.resourceForId("addremove.xml");
            ResourceTest.assertNotNull((Object)located);
            this.removeDocument("addremove.xml");
            XMLResource locatedAfterRemove = this.resourceForId("addremove.xml");
            ResourceTest.assertNull((Object)locatedAfterRemove);
        }
        catch (Exception e) {
            ResourceTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDocument(String id) throws XMLDBException {
        XMLResource resource = this.resourceForId(id);
        if (null != resource) {
            Collection collection = null;
            try {
                collection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
                collection.removeResource((Resource)resource);
            }
            finally {
                this.closeCollection(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLResource addResource(String id, String content) throws XMLDBException {
        Collection collection = null;
        XMLResource result = null;
        try {
            collection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            result = (XMLResource)collection.createResource(id, "XMLResource");
            result.setContent((Object)content);
            collection.storeResource((Resource)result);
        }
        finally {
            this.closeCollection(collection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLResource resourceForId(String id) throws XMLDBException {
        Collection collection = null;
        XMLResource result = null;
        try {
            collection = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
            result = (XMLResource)collection.getResource(id);
        }
        finally {
            this.closeCollection(collection);
        }
        return result;
    }

    private void closeCollection(Collection collection) throws XMLDBException {
        if (null != collection) {
            collection.close();
        }
    }

    private String xmlForTest() {
        return "<test><title>Title</title><para>Paragraph1</para><para>Paragraph2</para></test>";
    }

    protected void setUp() {
        try {
            Class<?> cl = Class.forName(DRIVER);
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Class)ResourceTest.class);
    }
}

