/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import org.exist.security.Permission;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.test.RemoteDBTest;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class RemoteDatabaseImplTest
extends RemoteDBTest {
    protected static final String ADMIN_PASSWORD = "somepwd";
    protected static final String ADMIN_COLLECTION_NAME = "admin-collection";

    public RemoteDatabaseImplTest(String name) {
        super(name);
    }

    public void testGetCollection() throws Exception {
        Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
        Database database = (Database)cl.newInstance();
        DatabaseManager.registerDatabase((Database)database);
        Collection rootCollection = DatabaseManager.getCollection((String)"xmldb:exist://localhost:8081/exist/xmlrpc/db", (String)"admin", null);
        CollectionManagementService cms = (CollectionManagementService)rootCollection.getService("CollectionManagementService", "1.0");
        Collection adminCollection = cms.createCollection(ADMIN_COLLECTION_NAME);
        UserManagementService ums = (UserManagementService)rootCollection.getService("UserManagementService", "1.0");
        if (ums != null) {
            Permission p = new Permission();
            p.setPermissions("user=+read,+write,group=-read,-write,other=-read,-write");
            ums.setPermissions(adminCollection, p);
            Collection guestCollection = DatabaseManager.getCollection((String)"xmldb:exist://localhost:8081/exist/xmlrpc/db/admin-collection", (String)"guest", (String)"guest");
            Resource resource = guestCollection.createResource("testguest", "BinaryResource");
            resource.setContent((Object)"123".getBytes());
            try {
                guestCollection.storeResource(resource);
                RemoteDatabaseImplTest.fail();
            }
            catch (XMLDBException e) {
                // empty catch block
            }
            cms.removeCollection(ADMIN_COLLECTION_NAME);
        }
    }
}

