/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import junit.framework.TestCase;
import org.exist.xmldb.DatabaseInstanceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.XMLResource;

public class IndexingTest
extends TestCase {
    private int siblingCount;
    private int depth;
    private Node deepBranch;
    private Random random;
    private static String driver = "org.exist.xmldb.DatabaseImpl";
    private static String baseURI = "xmldb:exist:///db";
    private static String username = "admin";
    private static String password = "";
    private static String name = "test.xml";
    private String EXIST_HOME = "";
    private int effectiveSiblingCount;
    private int effectiveDepth;
    private long startTime;
    private int arity;
    private boolean randomSizes;

    protected void setUp() throws Exception {
        super.setUp();
        this.siblingCount = 2;
        this.depth = 16;
        this.arity = 16;
        this.randomSizes = false;
        this.random = new Random(1234L);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public IndexingTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        System.setProperty("exist.initdb", "true");
        IndexingTest tester = new IndexingTest("");
        tester.testIrregularilyStructured(true);
    }

    public void testIrregularilyStructured() {
        this.testIrregularilyStructured(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testIrregularilyStructured(boolean getContentAsDOM) {
        Node n;
        Database database = null;
        String testName = "IrregularilyStructured";
        this.startTime = System.currentTimeMillis();
        System.out.println("Running test IrregularilyStructured ...");
        if (this.EXIST_HOME != "") {
            System.setProperty("exist.home", this.EXIST_HOME);
        }
        Class<?> dbc = Class.forName("org.exist.xmldb.DatabaseImpl");
        database = (Database)dbc.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
        Collection coll = DatabaseManager.getCollection((String)baseURI, (String)username, (String)password);
        XMLResource resource = (XMLResource)coll.createResource(name, "XMLResource");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.effectiveSiblingCount = this.populate(doc);
        this.printTime();
        resource.setContentAsDOM((Node)doc);
        this.printTime();
        coll.storeResource((Resource)resource);
        System.out.println("TEST> stored Resource " + name);
        this.printTime();
        coll.close();
        coll = DatabaseManager.getCollection((String)baseURI, (String)username, (String)password);
        resource = (XMLResource)coll.getResource(name);
        System.out.println("TEST> retrieved Resource " + name);
        this.printTime();
        if (getContentAsDOM) {
            n = resource.getContentAsDOM();
        } else {
            byte[] bytes;
            String s = (String)resource.getContent();
            try {
                bytes = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = s.getBytes();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            n = db.parse(bais);
        }
        System.out.println("getContentAsDOM: " + n.getNodeName());
        Element documentElement = null;
        if (n instanceof Element) {
            documentElement = (Element)n;
        } else if (n instanceof Document) {
            documentElement = ((Document)n).getDocumentElement();
        }
        this.assertions(documentElement);
        coll.removeResource((Resource)resource);
        System.out.println("TEST> IrregularilyStructured : PASSED");
        Object var14_15 = null;
        this.printTime();
        if (database == null) return;
        try {
            Collection coll2 = DatabaseManager.getCollection((String)baseURI, (String)username, (String)password);
            DatabaseManager.deregisterDatabase((Database)database);
            DatabaseInstanceManager dim = (DatabaseInstanceManager)coll2.getService("DatabaseInstanceManager", "1.0");
            dim.shutdown();
            this.printTime();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                System.out.println("TEST> IrregularilyStructured : FAILED");
                e.printStackTrace();
                Object var14_16 = null;
                this.printTime();
                if (database == null) return;
                try {
                    Collection coll2 = DatabaseManager.getCollection((String)baseURI, (String)username, (String)password);
                    DatabaseManager.deregisterDatabase((Database)database);
                    DatabaseInstanceManager dim = (DatabaseInstanceManager)coll2.getService("DatabaseInstanceManager", "1.0");
                    dim.shutdown();
                    this.printTime();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this.printTime();
            if (database == null) throw throwable;
            try {
                Collection coll2 = DatabaseManager.getCollection((String)baseURI, (String)username, (String)password);
                DatabaseManager.deregisterDatabase((Database)database);
                DatabaseInstanceManager dim = (DatabaseInstanceManager)coll2.getService("DatabaseInstanceManager", "1.0");
                dim.shutdown();
                this.printTime();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void printTime() {
        System.out.println("Current ellapsed time : " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f);
    }

    private void assertions(Element documentElement) {
        int computedSiblingCount = documentElement.getChildNodes().getLength();
        int computedDepth = ((Element)this.deepBranch).getElementsByTagName("element").getLength();
        int computedElementCount = documentElement.getElementsByTagName("element").getLength();
        System.out.println(" documentElement.getChildNodes().getLength(): " + computedSiblingCount);
        System.out.println(" documentElement.getElementsByTagName(\"element\").getLength(): " + computedElementCount);
        IndexingTest.assertEquals((String)"siblingCount", (int)this.effectiveSiblingCount, (int)computedSiblingCount);
        IndexingTest.assertEquals((String)"depth", (int)(this.depth * this.arity + this.depth), (int)computedDepth);
        System.out.println("TEST> assertions PASSED");
        this.printTime();
    }

    private int populate(Document doc) {
        int childrenCount = this.addChildren(doc, this.siblingCount);
        this.deepBranch = doc.getDocumentElement().getFirstChild();
        this.effectiveDepth = this.addFatBranch(doc, this.deepBranch, this.depth, null);
        System.out.println("TEST> populate() done.");
        return childrenCount;
    }

    private int populateOK(Document doc) {
        int j;
        int childrenCount = this.addChildren(doc, this.siblingCount);
        this.addBranch(doc, doc.getDocumentElement().getFirstChild(), this.depth, null);
        this.deepBranch = doc.getDocumentElement().getLastChild();
        this.effectiveDepth = this.addBranch(doc, this.deepBranch, this.depth, null);
        Element documentElement = doc.getDocumentElement();
        int firstLevelWidth = doc.getDocumentElement().getChildNodes().getLength();
        Node current = documentElement.getFirstChild();
        for (j = 0; j < firstLevelWidth - 1; ++j) {
            this.addBranch(doc, current, 10, "branch");
            current = current.getNextSibling();
        }
        current = documentElement.getFirstChild();
        for (j = 0; j < firstLevelWidth - 1; ++j) {
            this.addChildren(current, this.arity, doc);
            current = current.getNextSibling();
        }
        System.out.println("TEST> " + firstLevelWidth + " first Level elements populated.");
        return childrenCount;
    }

    private int addBranch(Document doc, Node branchNode, int depth, String elementName) {
        int rdepth = 0;
        if (branchNode != null) {
            Node current = branchNode;
            if (elementName == null || elementName == "") {
                elementName = "element";
            }
            rdepth = this.randomSizes ? this.random.nextInt(depth) : depth;
            for (int j = 0; j < rdepth; ++j) {
                Element el = doc.createElement(elementName);
                current.appendChild(el);
                current = el;
            }
        }
        return rdepth;
    }

    private int addFatBranch(Document doc, Node branchNode, int depth, String elementName) {
        int rdepth = 0;
        if (branchNode != null) {
            Node current = branchNode;
            if (elementName == null || elementName == "") {
                elementName = "element";
            }
            rdepth = this.randomSizes ? this.random.nextInt(depth) : depth;
            for (int j = 0; j < rdepth; ++j) {
                Element el = doc.createElement(elementName);
                this.addChildren(el, this.arity, doc);
                current.appendChild(el);
                current = el;
            }
        }
        return rdepth;
    }

    private int addChildren(Document doc, int length) {
        Element rootElem = doc.createElement("root");
        doc.appendChild(rootElem);
        return this.addChildren(rootElem, length, doc);
    }

    private int addChildren(Node rootElem, int length, Document doc) {
        int rlength = 0;
        if (rootElem != null) {
            rlength = this.randomSizes ? this.random.nextInt(length) : length;
            for (int j = 0; j < rlength; ++j) {
                Element el = doc.createElement("element");
                rootElem.appendChild(el);
            }
        }
        return rlength;
    }

    private void dumpCatabaseContent(Node n) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Transformer t = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(n);
        SAXResult result = new SAXResult(new SAXHandler());
        t.transform(source, result);
    }

    class SAXHandler
    implements ContentHandler {
        SAXHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            System.out.println("SAXHandler.characters(" + new String(ch) + ", " + start + ", " + length + ")");
        }

        public void endDocument() {
            System.out.println("SAXHandler.endDocument()");
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            System.out.println("SAXHandler.endElement(" + namespaceURI + ", " + localName + ", " + qName + ")");
        }

        public void endPrefixMapping(String prefix) {
            System.out.println("SAXHandler.endPrefixMapping(" + prefix + ")");
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            System.out.println("SAXHandler.ignorableWhitespace(" + new String(ch) + ", " + start + ", " + length + ")");
        }

        public void processingInstruction(String target, String data) {
            System.out.println("SAXHandler.processingInstruction(" + target + ", " + data + ")");
        }

        public void setDocumentLocator(Locator locator) {
            System.out.println("SAXHandler.setDocumentLocator(" + locator + ")");
        }

        public void skippedEntity(String name) {
            System.out.println("SAXHandler.skippedEntity(" + name + ")");
        }

        public void startDocument() {
            System.out.println("SAXHandler.startDocument()");
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            System.out.println("SAXHandler.startElement(" + namespaceURI + ", " + localName + ", " + qName + "," + atts + ")");
        }

        public void startPrefixMapping(String prefix, String xuri) {
            System.out.println("SAXHandler.startPrefixMapping(" + prefix + ", " + xuri + ")");
        }
    }
}

